/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.jamon.codegen.SequentialIterator;

class Concatenation<T>
extends AbstractCollection<T> {
    private final Collection<? extends T>[] collections;
    private final int size;

    private Concatenation(Collection<? extends T> ... collections) {
        this.collections = collections;
        this.size = Concatenation.totalSize(collections);
    }

    private static int totalSize(Collection<?> ... collections) {
        int size = 0;
        for (Collection<?> collection : collections) {
            size += collection.size();
        }
        return size;
    }

    public Concatenation(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        this(new Collection[]{collection1, collection2});
    }

    public Concatenation(Collection<? extends T> collection1, Collection<? extends T> collection2, Collection<? extends T> collection3) {
        this(new Collection[]{collection1, collection2, collection3});
    }

    @Override
    public Iterator<T> iterator() {
        Iterator[] iters = new Iterator[this.collections.length];
        for (int i = 0; i < this.collections.length; ++i) {
            iters[i] = this.collections[i].iterator();
        }
        return new SequentialIterator(iters);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> collection : this.collections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }
}

