/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.RequiredArgument;
import org.jamon.compiler.ParserErrorImpl;

public class NamedParamValues
implements ParamValues {
    private final Map<String, String> params;
    private final Location location;

    public NamedParamValues(Map<String, String> params, Location location) {
        this.params = params == null ? Collections.emptyMap() : params;
        this.location = location;
    }

    @Override
    public void generateRequiredArgs(List<RequiredArgument> args, CodeWriter writer) throws ParserErrorImpl {
        boolean multipleArgsAreMissing = false;
        StringBuilder missingArgs = null;
        for (RequiredArgument arg : args) {
            String name = arg.getName();
            String expr = this.params.remove(name);
            if (expr == null) {
                if (missingArgs == null) {
                    missingArgs = new StringBuilder(name);
                } else {
                    multipleArgsAreMissing = true;
                    missingArgs.append(", " + name);
                }
            }
            writer.printListElement(expr);
        }
        if (missingArgs != null) {
            String plural = multipleArgsAreMissing ? "s" : "";
            throw new ParserErrorImpl(this.location, "No value" + plural + " supplied for required argument" + plural + " " + missingArgs.toString());
        }
    }

    @Override
    public String getOptionalArgValue(String argName) {
        return this.params.remove(argName);
    }

    @Override
    public boolean hasUnusedParams() {
        return !this.params.isEmpty();
    }

    @Override
    public Iterable<String> getUnusedParams() {
        return this.params.keySet();
    }
}

