/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jamon.api.TemplateLocation;
import org.jamon.api.TemplateSource;
import org.jamon.compiler.TemplateFileLocation;

public class FileTemplateSource
implements TemplateSource {
    private final File templateSourceDir;
    private final String extension;

    public FileTemplateSource(String templateSourceDir) {
        this(new File(templateSourceDir));
    }

    public FileTemplateSource(File templateSourceDir) {
        this(templateSourceDir, "jamon");
    }

    public FileTemplateSource(File templateSourceDir, String extension) {
        this.templateSourceDir = templateSourceDir;
        this.extension = extension == null || extension.length() == 0 ? "" : "." + extension;
    }

    public long lastModified(String templatePath) {
        return this.getTemplateFile(templatePath).lastModified();
    }

    public boolean available(String templatePath) {
        return this.getTemplateFile(templatePath).exists();
    }

    public InputStream getStreamFor(String templatePath) throws IOException {
        return new FileInputStream(this.getTemplateFile(templatePath));
    }

    public String getExternalIdentifier(String templatePath) {
        return this.getTemplateFile(templatePath).getAbsolutePath();
    }

    private File getTemplateFile(String templatePath) {
        return new File(this.templateSourceDir, FileTemplateSource.templatePathToFilePath(templatePath) + this.extension);
    }

    private static String templatePathToFilePath(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuilder convertedPath = new StringBuilder(path.length());
        while (tokenizer.hasMoreTokens()) {
            convertedPath.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            convertedPath.append(File.separator);
        }
        return convertedPath.toString();
    }

    public TemplateLocation getTemplateLocation(String templatePath) {
        return new TemplateFileLocation(this.getExternalIdentifier(templatePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String path, Properties properties) throws IOException {
        File propertiesFile = new File(this.templateSourceDir, FileTemplateSource.templatePathToFilePath(path + "/jamon.properties"));
        if (propertiesFile.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(propertiesFile);
            try {
                properties.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }
}

