/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.api.ParserError;
import org.jamon.api.ParserErrors;
import org.jamon.compiler.ParserErrorImpl;

public final class ParserErrorsImpl
extends IOException
implements ParserErrors {
    private final List<ParserError> errors = new ArrayList<ParserError>();
    private static final long serialVersionUID = 2006091701L;

    public ParserErrorsImpl() {
    }

    public ParserErrorsImpl(ParserError p_error) {
        this.errors.add(p_error);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ParserError> getErrors() {
        return this.errors;
    }

    public void addError(ParserError p_error) {
        this.errors.add(p_error);
    }

    public void addError(String message, Location location) {
        this.addError(new ParserErrorImpl(location, message));
    }

    public void addErrors(ParserErrorsImpl p_errors) {
        this.errors.addAll(p_errors.errors);
    }

    @Override
    public String getMessage() {
        StringBuilder buffer = new StringBuilder("Errors occured during parsing:");
        for (ParserError error : this.getErrors()) {
            buffer.append("\n   ");
            buffer.append(error.toString());
        }
        return buffer.toString();
    }

    public void printErrors(PrintStream stream) {
        for (ParserError error : this.getErrors()) {
            stream.println(error);
        }
    }
}

