/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import org.jamon.api.Location;
import org.jamon.node.Analysis;

public abstract class AbstractNode {
    private final Location location;

    protected AbstractNode(Location location) {
        this.location = location;
        if (this.location == null) {
            throw new NullPointerException();
        }
    }

    public final Location getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractNode && this.getClass().isInstance(obj) && this.location.equals(((AbstractNode)obj).location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public abstract void apply(Analysis var1);

    protected void propertiesToString(StringBuilder buffer) {
        buffer.append(this.location.toString());
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("{");
        this.propertiesToString(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    protected static void addProperty(StringBuilder buffer, String label, char character) {
        buffer.append(", ");
        buffer.append(label);
        buffer.append(": ");
        buffer.append(character);
    }

    protected static void addProperty(StringBuilder buffer, String label, Object obj) {
        buffer.append(", ");
        buffer.append(label);
        buffer.append(": ");
        buffer.append(obj.toString());
    }

    protected static void addPropertyList(StringBuilder buffer, String name, Iterable<? extends AbstractNode> properties) {
        buffer.append(", ");
        buffer.append(name);
        buffer.append(": [");
        boolean seenElement = false;
        for (AbstractNode abstractNode : properties) {
            if (seenElement) {
                buffer.append(", ");
            } else {
                seenElement = true;
            }
            buffer.append(abstractNode.toString());
        }
        buffer.append("]");
    }
}

