/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.AbstractCallNode;
import org.jamon.node.AbstractComponentCallNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.ChildCallNode;
import org.jamon.node.FragmentCallNode;
import org.jamon.node.GenericCallParam;
import org.jamon.node.MultiFragmentCallNode;
import org.jamon.node.NamedFragmentNode;
import org.jamon.node.NamedParamNode;
import org.jamon.node.NamedParamsNode;
import org.jamon.node.NoParamsNode;
import org.jamon.node.ParamNameNode;
import org.jamon.node.ParamValueNode;
import org.jamon.node.SimpleCallNode;
import org.jamon.node.UnnamedFragmentNode;
import org.jamon.node.UnnamedParamsNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.ClassNameParser;
import org.jamon.parser.NamedFragmentParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.UnnamedFragmentParser;

public class CallParser
extends AbstractParser {
    public static final String INVALID_CALL_TARGET_ERROR = "Invalid call target";
    public static final String MISSING_CALL_CLOSE_ERROR = "Expecting '&>'";
    public static final String UNEXPECTED_IN_MULTI_FRAG_ERROR = "Expecting either '<|identifier>' or '</&>'";
    public static final String MISSING_ARG_ARROW_ERROR = "Expecting '=' or '=>' to separate param name and value";
    public static final String GENERIC_ERROR = "Malformed call tag";
    public static final String PARAM_VALUE_EOF_ERROR = "Reached end of file while reading parameter value";
    public static final String FRAGMENTS_EOF_ERROR = "Reached end of file while reading call fragments; '</&>' Expected";
    public static final String MISSING_GENERIC_PARAM_CLOSE_ERROR = "Expecing ',' or '>'";
    private AbstractCallNode callNode;
    private List<GenericCallParam> genericParams = null;

    public CallParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location callStartLocation) throws IOException {
        super(reader, errors);
        try {
            if (this.readChar('|')) {
                this.callNode = this.readChar('|') ? this.parseNamedFragmentCall(callStartLocation) : this.parseUnnamedFragmentCall(callStartLocation);
                this.addGenericParams();
            } else {
                this.soakWhitespace();
                if (this.readChar('*')) {
                    this.parseChildCall(callStartLocation);
                } else {
                    AbstractPathNode path = this.parsePath();
                    this.parseGenericParams();
                    this.callNode = new SimpleCallNode(callStartLocation, path, this.parseParams());
                    this.addGenericParams();
                }
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            this.callNode = new SimpleCallNode(callStartLocation, new AbsolutePathNode(callStartLocation), new NoParamsNode(reader.getLocation()));
        }
    }

    private void parseChildCall(Location callStartLocation) throws IOException, ParserErrorImpl {
        Location callTargetLocation = this.reader.getLocation();
        if (this.checkToken("CHILD")) {
            this.soakWhitespace();
            Location endLocation = this.reader.getNextLocation();
            if (!this.checkToken("&>")) {
                throw new ParserErrorImpl(endLocation, MISSING_CALL_CLOSE_ERROR);
            }
        } else {
            throw new ParserErrorImpl(callTargetLocation, INVALID_CALL_TARGET_ERROR);
        }
        this.callNode = new ChildCallNode(callStartLocation);
    }

    private AbstractComponentCallNode parseNamedFragmentCall(Location callStartLocation) throws IOException, ParserErrorImpl {
        int c;
        this.soakWhitespace();
        AbstractPathNode path = this.parsePath();
        this.parseGenericParams();
        MultiFragmentCallNode callNode = new MultiFragmentCallNode(callStartLocation, path, this.parseParams());
        Location fragmentsStart = this.reader.getNextLocation();
        while (true) {
            this.soakWhitespace();
            Location fragmentStart = this.reader.getNextLocation();
            c = this.reader.read();
            if (c != 60) break;
            switch (this.reader.read()) {
                case 124: {
                    String name = this.readIdentifier(true);
                    if (this.readChar('>')) {
                        NamedFragmentNode fragmentNode = new NamedFragmentNode(fragmentStart, name);
                        new NamedFragmentParser(fragmentNode, this.reader, this.errors).parse();
                        callNode.addFragment(fragmentNode);
                        break;
                    }
                    throw new ParserErrorImpl(this.reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
                case 47: {
                    if (this.readChar('&') && this.readChar('>')) {
                        return callNode;
                    }
                    throw new ParserErrorImpl(this.reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
                default: {
                    throw new ParserErrorImpl(this.reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
            }
        }
        if (c >= 0) {
            throw new ParserErrorImpl(this.reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
        }
        throw new ParserErrorImpl(fragmentsStart, FRAGMENTS_EOF_ERROR);
    }

    private FragmentCallNode parseUnnamedFragmentCall(Location callStartLocation) throws IOException, ParserErrorImpl {
        this.soakWhitespace();
        AbstractPathNode path = this.parsePath();
        this.parseGenericParams();
        AbstractParamsNode params = this.parseParams();
        return new FragmentCallNode(callStartLocation, path, params, (UnnamedFragmentNode)new UnnamedFragmentParser(new UnnamedFragmentNode(this.reader.getNextLocation()), this.reader, this.errors).parse().getRootNode());
    }

    private AbstractParamsNode parseParams() throws IOException, ParserErrorImpl {
        this.soakWhitespace();
        this.reader.markNodeEnd();
        int c = this.reader.read();
        switch (c) {
            case 38: {
                if (this.reader.read() == 62) {
                    return new NoParamsNode(this.reader.getCurrentNodeLocation());
                }
                throw new ParserErrorImpl(this.reader.getLocation(), GENERIC_ERROR);
            }
            case 59: {
                return this.parseNamedParams();
            }
            case 58: {
                return this.parseUnnamedParams();
            }
        }
        throw new ParserErrorImpl(this.reader.getLocation(), GENERIC_ERROR);
    }

    private NamedParamsNode parseNamedParams() throws ParserErrorImpl, IOException {
        NamedParamsNode params = new NamedParamsNode(this.reader.getLocation());
        ParamValueEndDetector endDetector = new ParamValueEndDetector();
        do {
            this.soakWhitespace();
            if (this.readChar('&')) {
                if (this.readChar('>')) {
                    return params;
                }
                throw new ParserErrorImpl(this.reader.getCurrentNodeLocation(), GENERIC_ERROR);
            }
            Location nameLoc = this.reader.getNextLocation();
            String name = this.readIdentifier(true);
            this.readArrow();
            Location javaLoc = this.reader.getNextLocation();
            params.addParam(new NamedParamNode(nameLoc, new ParamNameNode(nameLoc, name), new ParamValueNode(javaLoc, this.readJava(javaLoc, endDetector))));
        } while (!endDetector.noMoreParams());
        return params;
    }

    private UnnamedParamsNode parseUnnamedParams() throws ParserErrorImpl, IOException {
        UnnamedParamsNode params = new UnnamedParamsNode(this.reader.getLocation());
        ParamValueEndDetector endDetector = new ParamValueEndDetector();
        do {
            this.soakWhitespace();
            if (this.readChar('&')) {
                if (this.readChar('>')) {
                    return params;
                }
                throw new ParserErrorImpl(this.reader.getCurrentNodeLocation(), GENERIC_ERROR);
            }
            Location javaLoc = this.reader.getNextLocation();
            params.addValue(new ParamValueNode(javaLoc, this.readJava(javaLoc, endDetector)));
        } while (!endDetector.noMoreParams());
        return params;
    }

    private void parseGenericParams() throws ParserErrorImpl, IOException {
        this.genericParams = new ArrayList<GenericCallParam>();
        if (this.readChar('<')) {
            do {
                this.soakWhitespace();
                Location location = this.reader.getNextLocation();
                this.genericParams.add(new GenericCallParam(location, new ClassNameParser(location, this.reader, this.errors).getType()));
                this.soakWhitespace();
            } while (this.readChar(','));
            if (!this.readChar('>')) {
                throw new ParserErrorImpl(this.reader.getNextLocation(), MISSING_GENERIC_PARAM_CLOSE_ERROR);
            }
        }
    }

    private void addGenericParams() {
        AbstractComponentCallNode componentCallNode = (AbstractComponentCallNode)this.callNode;
        for (GenericCallParam param : this.genericParams) {
            componentCallNode.addGenericParam(param);
        }
    }

    private void readArrow() throws ParserErrorImpl, IOException {
        this.soakWhitespace();
        if (!this.readChar('=')) {
            throw new ParserErrorImpl(this.reader.getNextLocation(), MISSING_ARG_ARROW_ERROR);
        }
        this.readChar('>');
        this.soakWhitespace();
    }

    public static void main(String[] args) {
    }

    public AbstractCallNode getCallNode() {
        return this.callNode;
    }

    private static class ParamValueEndDetector
    implements TagEndDetector {
        private boolean noMoreParams = false;
        private boolean seenAmpersand = false;

        private ParamValueEndDetector() {
        }

        public boolean noMoreParams() {
            return this.noMoreParams;
        }

        @Override
        public int checkEnd(char character) {
            if (character == '&') {
                this.seenAmpersand = true;
                return 0;
            }
            if (character == '>' && this.seenAmpersand) {
                this.noMoreParams = true;
                return 2;
            }
            if (character == ';') {
                return 1;
            }
            this.seenAmpersand = false;
            return 0;
        }

        @Override
        public ParserErrorImpl getEofError(Location startLocation) {
            return new ParserErrorImpl(startLocation, CallParser.PARAM_VALUE_EOF_ERROR);
        }

        @Override
        public void resetEndMatch() {
            this.seenAmpersand = false;
        }
    }
}

