/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.GenericsBoundNode;
import org.jamon.node.GenericsNode;
import org.jamon.node.GenericsParamNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class GenericsParser
extends AbstractParser {
    static final String EXPECTING_EXTENDS_OR_GENERIC_ERROR = "expecting ',', 'extends' or '</%generic>";
    static final String TYPE_PARAMETER_EXPECTED_ERROR = "type parameter expected";
    static final String EXPECTING_GENERIC_ERROR = "expecting '</%generic>'";
    private final GenericsNode genericsNode;

    public GenericsParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location tagLocation) throws IOException {
        super(reader, errors);
        this.genericsNode = new GenericsNode(tagLocation);
        this.checkForTagClosure(tagLocation);
        block7: while (true) {
            this.soakWhitespace();
            reader.markNodeEnd();
            String paramName = null;
            try {
                paramName = this.readIdentifierOrThrow();
            }
            catch (AbstractParser.NotAnIdentifierException e) {
                this.addError(reader.getCurrentNodeLocation(), TYPE_PARAMETER_EXPECTED_ERROR);
                return;
            }
            GenericsParamNode param = new GenericsParamNode(reader.getCurrentNodeLocation(), paramName);
            this.genericsNode.addParam(param);
            this.soakWhitespace();
            int c = reader.read();
            switch (c) {
                case 44: {
                    break;
                }
                case 60: {
                    if (!this.checkToken("/%generic>")) {
                        this.addError(reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    }
                    this.soakWhitespace();
                    return;
                }
                case 101: {
                    if (this.checkToken("xtends")) {
                        if (!this.soakWhitespace()) {
                            this.addError(reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                            return;
                        }
                        boolean readingBounds = true;
                        while (readingBounds) {
                            reader.markNodeEnd();
                            String bound = this.readClassName(reader.getNextLocation());
                            if (bound.length() == 0) {
                                return;
                            }
                            param.addBound(new GenericsBoundNode(reader.getCurrentNodeLocation(), bound));
                            this.soakWhitespace();
                            readingBounds = this.readChar('&');
                            if (!readingBounds) continue;
                            this.soakWhitespace();
                        }
                        if (this.readChar(',')) continue block7;
                        if (!this.checkToken("</%generic>")) {
                            this.addError(reader.getLocation(), EXPECTING_GENERIC_ERROR);
                        }
                        this.soakWhitespace();
                        return;
                    }
                    this.addError(reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    return;
                }
                default: {
                    this.addError(reader.getLocation(), EXPECTING_EXTENDS_OR_GENERIC_ERROR);
                    return;
                }
            }
        }
    }

    public GenericsNode getGenericsNode() {
        return this.genericsNode;
    }
}

