/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.parser.TagEndDetector;

public class HashEndDetector
implements TagEndDetector {
    private boolean endedWithHash = false;
    private boolean seenPercent = false;

    @Override
    public int checkEnd(char character) {
        switch (character) {
            case '%': {
                this.seenPercent = true;
                return 0;
            }
            case '>': {
                if (this.seenPercent) {
                    this.endedWithHash = false;
                    return 2;
                }
                this.seenPercent = false;
                return 0;
            }
            case '#': {
                this.endedWithHash = true;
                return 1;
            }
        }
        this.seenPercent = false;
        return 0;
    }

    @Override
    public ParserErrorImpl getEofError(Location startLocation) {
        return new ParserErrorImpl(startLocation, "Reached end of file while looking for '%>'");
    }

    @Override
    public void resetEndMatch() {
    }

    public boolean endedWithHash() {
        return this.endedWithHash;
    }
}

