/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractBodyNode;
import org.jamon.node.ElseIfNode;
import org.jamon.node.ElseNode;
import org.jamon.parser.AbstractFlowControlBlockParser;
import org.jamon.parser.PositionalPushbackReader;

public class IfParser
extends AbstractFlowControlBlockParser<AbstractBodyNode> {
    public static final String ENCOUNTERED_MULTIPLE_ELSE_TAGS_FOR_ONE_IF_TAG = "encountered multiple <%else> tags for one <%if ...%> tag";
    private IfParser continuation;

    public IfParser(AbstractBodyNode node, PositionalPushbackReader reader, ParserErrorsImpl errors) {
        super(node, reader, errors);
    }

    @Override
    protected void handleElseTag(Location tagLocation) throws IOException {
        if (this.processingElseNode()) {
            this.addError(tagLocation, ENCOUNTERED_MULTIPLE_ELSE_TAGS_FOR_ONE_IF_TAG);
        } else {
            if (this.checkForTagClosure(tagLocation)) {
                this.continuation = new IfParser(new ElseNode(tagLocation), this.reader, this.errors);
                this.continuation.parse();
            }
            this.doneParsing();
        }
    }

    @Override
    protected void handleElseIfTag(Location tagLocation) throws IOException {
        if (this.processingElseNode()) {
            this.addError(tagLocation, ENCOUNTERED_MULTIPLE_ELSE_TAGS_FOR_ONE_IF_TAG);
        } else {
            try {
                this.continuation = new IfParser(new ElseIfNode(tagLocation, this.readCondition(tagLocation, "elseif")), this.reader, this.errors);
                this.continuation.parse();
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
            this.doneParsing();
        }
    }

    private boolean processingElseNode() {
        return this.root instanceof ElseNode;
    }

    public IfParser getContinuation() {
        return this.continuation;
    }

    @Override
    protected String tagName() {
        return "if";
    }
}

