/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.io.Reader;
import org.jamon.api.Location;
import org.jamon.api.TemplateLocation;
import org.jamon.codegen.AnnotationType;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsMethodNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.AliasDefNode;
import org.jamon.node.AliasesNode;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ClassNode;
import org.jamon.node.EscapeDirectiveNode;
import org.jamon.node.ExtendsNode;
import org.jamon.node.ImplementNode;
import org.jamon.node.ImplementsNode;
import org.jamon.node.ImportsNode;
import org.jamon.node.LocationImpl;
import org.jamon.node.ParentMarkerNode;
import org.jamon.node.ReplaceableNode;
import org.jamon.node.ReplacesNode;
import org.jamon.node.TopNode;
import org.jamon.parser.AbstractBodyParser;
import org.jamon.parser.ArgsParser;
import org.jamon.parser.DefParser;
import org.jamon.parser.FragmentArgsParser;
import org.jamon.parser.GenericsParser;
import org.jamon.parser.HashEndDetector;
import org.jamon.parser.ImportParser;
import org.jamon.parser.MethodParser;
import org.jamon.parser.OverrideParser;
import org.jamon.parser.ParentArgsParser;
import org.jamon.parser.PositionalPushbackReader;

public class TopLevelParser
extends AbstractBodyParser<TopNode> {
    public static final String BAD_ABSMETH_CONTENT = "<%absmeth> sections can only contain <%args> and <%frag> blocks";
    public static final String EXPECTING_SEMI = "Expecting ';'";
    public static final String EXPECTING_ARROW = "Expecting '=' or '=>'";
    public static final String MALFORMED_EXTENDS_TAG_ERROR = "Malformed <%extends ...> tag";
    public static final String MALFORMED_REPLACES_TAG_ERROR = "Malformed <%replaces ...> tag";
    public static final String MALFORMED_ANNOTATE_TAG_ERROR = "Malformed <%annotate...> tag";
    public static final String UNRECOGNIZED_ANNOTATION_TYPE_ERROR = "Unrecognized annotation type";
    private static final String BAD_ALIASES_CLOSE_TAG = "Malformed </%alias> tag";
    private static final String BAD_ABS_METHOD_CLOSE_TAG = "Malformed </%absmeth> tag";
    public static final String EXPECTING_IMPLEMENTS_CLOSE = "Expecting class name or </%implements>";
    public static final String EXPECTING_IMPORTS_CLOSE = "Expecting import or </%import>";

    public TopLevelParser(TemplateLocation location, Reader reader, String encoding) {
        super(new TopNode(new LocationImpl(location, 1, 1), encoding), new PositionalPushbackReader(location, reader, 2), new ParserErrorsImpl());
    }

    @Override
    public AbstractBodyParser<TopNode> parse() throws IOException {
        super.parse();
        if (this.errors.hasErrors()) {
            throw this.errors;
        }
        return this;
    }

    @Override
    protected void handleMethodTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(tagLocation)) {
                ((TopNode)this.root).addSubNode((AbstractNode)new MethodParser(name, tagLocation, this.reader, this.errors).parse().getRootNode());
            }
        } else {
            this.addError(tagLocation, "malformed <%method methodName> tag");
        }
    }

    @Override
    protected void handleOverrideTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(tagLocation)) {
                ((TopNode)this.root).addSubNode((AbstractNode)new OverrideParser(name, tagLocation, this.reader, this.errors).parse().getRootNode());
            }
        } else {
            this.addError(tagLocation, "malformed <%override methodName> tag");
        }
    }

    @Override
    protected void handleDefTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(tagLocation)) {
                ((TopNode)this.root).addSubNode((AbstractNode)new DefParser(name, tagLocation, this.reader, this.errors).parse().getRootNode());
            }
        } else {
            this.addError(tagLocation, "malformed <%def defName> tag");
        }
    }

    @Override
    protected void handleClassTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ((TopNode)this.root).addSubNode(new ClassNode(tagLocation, this.readUntil("</%class>", tagLocation)));
            this.soakWhitespace();
        }
    }

    @Override
    protected void handleExtendsTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            ((TopNode)this.root).addSubNode(new ExtendsNode(tagLocation, this.parsePath()));
            this.soakWhitespace();
            this.checkForTagClosure(this.reader.getLocation());
            this.soakWhitespace();
        } else {
            this.addError(tagLocation, MALFORMED_EXTENDS_TAG_ERROR);
        }
    }

    @Override
    protected void handleReplacesTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            ((TopNode)this.root).addSubNode(new ReplacesNode(tagLocation, this.parsePath()));
            this.soakWhitespace();
            this.checkForTagClosure(this.reader.getLocation());
            this.soakWhitespace();
        } else {
            this.addError(tagLocation, MALFORMED_REPLACES_TAG_ERROR);
        }
    }

    @Override
    protected void handleReplaceableTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ((TopNode)this.root).addSubNode(new ReplaceableNode(tagLocation));
            this.soakWhitespace();
        }
    }

    @Override
    protected void handleImplementsTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ImplementsNode implementsNode = new ImplementsNode(tagLocation);
            ((TopNode)this.root).addSubNode(implementsNode);
            while (true) {
                this.soakWhitespace();
                Location location = this.reader.getNextLocation();
                if (this.readChar('<')) {
                    if (!this.checkToken("/%implements>")) {
                        this.addError(location, EXPECTING_IMPLEMENTS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                String className = this.readClassName(this.reader.getCurrentNodeLocation());
                if (className.length() == 0) {
                    this.addError(location, EXPECTING_IMPLEMENTS_CLOSE);
                    return;
                }
                if (!this.readChar(';')) {
                    this.addError(this.reader.getNextLocation(), EXPECTING_SEMI);
                }
                implementsNode.addImplement(new ImplementNode(location, className));
            }
        }
    }

    @Override
    protected void handleImportTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ImportsNode importsNode = new ImportsNode(tagLocation);
            ((TopNode)this.root).addSubNode(importsNode);
            while (true) {
                this.soakWhitespace();
                Location location = this.reader.getNextLocation();
                if (this.readChar('<')) {
                    if (!this.checkToken("/%import>")) {
                        this.addError(location, EXPECTING_IMPORTS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                try {
                    importsNode.addImport(new ImportParser(this.reader, this.errors).parse().getNode());
                }
                catch (ParserErrorImpl e) {
                    this.addError(e);
                    this.addError(this.reader.getLocation(), EXPECTING_IMPORTS_CLOSE);
                    return;
                }
                this.soakWhitespace();
                if (this.readChar(';')) continue;
                this.addError(this.reader.getNextLocation(), EXPECTING_SEMI);
            }
        }
    }

    @Override
    protected void handleAliasesTag(Location tagLocation) throws IOException {
        this.checkForTagClosure(tagLocation);
        AliasesNode aliases = new AliasesNode(tagLocation);
        ((TopNode)this.root).addSubNode(aliases);
        while (true) {
            String name;
            this.soakWhitespace();
            this.reader.markNodeEnd();
            if (this.readChar('<')) {
                if (!this.checkToken("/%alias>")) {
                    this.addError(this.reader.getLocation(), BAD_ALIASES_CLOSE_TAG);
                }
                this.soakWhitespace();
                return;
            }
            String string = name = this.readChar('/') ? "/" : this.readIdentifier(false);
            if (name.length() == 0) {
                this.addError(this.reader.getCurrentNodeLocation(), "Alias name expected");
                return;
            }
            this.soakWhitespace();
            if (this.readChar('=')) {
                this.readChar('>');
                this.soakWhitespace();
                AbstractPathNode path = this.parsePath();
                if (path.getPathElements().isEmpty()) {
                    return;
                }
                aliases.addAlias(new AliasDefNode(this.reader.getCurrentNodeLocation(), name, path));
                if (this.readChar(';')) continue;
                this.addError(this.reader.getLocation(), EXPECTING_SEMI);
                continue;
            }
            this.addError(this.reader.getLocation(), EXPECTING_ARROW);
        }
    }

    @Override
    protected void handleAbsMethodTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            block8: {
                block9: {
                    String name = this.readIdentifier(true);
                    this.checkForTagClosure(tagLocation);
                    AbsMethodNode absMethodNode = new AbsMethodNode(tagLocation, name);
                    ((TopNode)this.root).addSubNode(absMethodNode);
                    while (true) {
                        this.soakWhitespace();
                        this.reader.markNodeEnd();
                        if (!this.readChar('<')) break block8;
                        if (!this.readChar('%')) break block9;
                        String tagName = this.readTagName();
                        if ("args".equals(tagName)) {
                            try {
                                absMethodNode.addArgsBlock(new ArgsParser(this.reader, this.errors, this.reader.getCurrentNodeLocation()).getArgsNode());
                            }
                            catch (ParserErrorImpl e) {
                                this.addError(e);
                            }
                            continue;
                        }
                        if (!"frag".equals(tagName)) break;
                        try {
                            absMethodNode.addArgsBlock(new FragmentArgsParser(this.reader, this.errors, this.reader.getCurrentNodeLocation()).getFragmentArgsNode());
                        }
                        catch (ParserErrorImpl e) {
                            this.addError(e);
                        }
                    }
                    this.addError(this.reader.getLocation(), BAD_ABSMETH_CONTENT);
                    return;
                }
                if (!this.checkToken("/%absmeth>")) {
                    this.addError(this.reader.getLocation(), BAD_ABS_METHOD_CLOSE_TAG);
                }
                this.soakWhitespace();
                return;
            }
            this.addError(this.reader.getLocation(), BAD_ABSMETH_CONTENT);
            return;
        }
        this.addError(this.reader.getLocation(), "malformed <%absmeth methodName> tag");
    }

    @Override
    protected void handleParentArgsNode(Location tagLocation) throws IOException {
        ((TopNode)this.root).addSubNode(new ParentArgsParser(this.reader, this.errors, tagLocation).getParentArgsNode());
    }

    @Override
    protected void handleParentMarkerTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ((TopNode)this.root).addSubNode(new ParentMarkerNode(tagLocation));
            this.soakWhitespace();
        }
    }

    @Override
    protected void handleEof() {
    }

    @Override
    protected void handleEscapeTag(Location tagLocation) throws IOException {
        this.soakWhitespace();
        if (!this.readChar('#')) {
            this.addError(this.reader.getNextLocation(), "Expecting '#'");
        } else {
            this.soakWhitespace();
            int c = this.reader.read();
            if (Character.isLetter((char)c)) {
                ((TopNode)this.root).addSubNode(new EscapeDirectiveNode(tagLocation, new String(new char[]{(char)c})));
            } else {
                this.addError(this.reader.getLocation(), "Expecting a letter");
            }
            this.soakWhitespace();
            this.checkForTagClosure(tagLocation);
        }
        this.soakWhitespace();
    }

    @Override
    protected void handleGenericTag(Location tagLocation) throws IOException {
        ((TopNode)this.root).addSubNode(new GenericsParser(this.reader, this.errors, tagLocation).getGenericsNode());
    }

    @Override
    protected void handleAnnotationTag(Location tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            try {
                AnnotationType annotationType;
                HashEndDetector detector = new HashEndDetector();
                String annotations = this.readJava(tagLocation, detector);
                if (detector.endedWithHash()) {
                    annotationType = this.readAnnotationType();
                    this.soakWhitespace();
                    if (!this.readChar('%') || !this.readChar('>')) {
                        throw new ParserErrorImpl(tagLocation, MALFORMED_ANNOTATE_TAG_ERROR);
                    }
                } else {
                    annotationType = AnnotationType.BOTH;
                }
                ((TopNode)this.root).addSubNode(new AnnotationNode(tagLocation, annotations, annotationType));
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
            this.soakWhitespace();
        } else {
            this.addError(tagLocation, MALFORMED_ANNOTATE_TAG_ERROR);
        }
    }

    private AnnotationType readAnnotationType() throws IOException, ParserErrorImpl {
        Location location = this.reader.getLocation();
        if (this.readChar('p')) {
            if (this.checkToken("roxy")) {
                return AnnotationType.PROXY;
            }
        } else if (this.readChar('i') && this.checkToken("mpl")) {
            return AnnotationType.IMPL;
        }
        throw new ParserErrorImpl(location, UNRECOGNIZED_ANNOTATION_TYPE_ERROR);
    }

    @Override
    protected boolean isTopLevel() {
        return true;
    }
}

