/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.File;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char TEMPLATE_PATH_SEPARATOR_CHAR = '/';
    private static final String TEMPLATE_PATH_SEPARATOR = "/";
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtils() {
    }

    public static String templatePathToFileDir(String path) {
        int k = path.lastIndexOf(47);
        if (k <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(path.substring(0, k));
        int j = 1;
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.substring(i, j).equals(TEMPLATE_PATH_SEPARATOR)) {
                sb.replace(i, j, File.separator);
            }
            ++j;
        }
        return sb.toString();
    }

    public static boolean isGeneratedClassFilename(String className, String fileName) {
        String rest;
        return fileName.endsWith(".class") && fileName.startsWith(className) && ((rest = fileName.substring(className.length())).equals(".class") || rest.charAt(0) == '$');
    }

    public static String templatePathToClassName(String path) {
        StringBuilder sb = new StringBuilder(path);
        while (sb.length() > 0 && '/' == sb.charAt(0)) {
            sb.delete(0, 1);
        }
        int j = 1;
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.substring(i, j).equals(TEMPLATE_PATH_SEPARATOR)) {
                sb.replace(i, j, ".");
            }
            ++j;
        }
        return sb.toString();
    }

    public static String classToTemplatePath(Class<?> clazz) {
        return StringUtils.filePathToTemplatePath(StringUtils.classNameToFilePath(clazz.getName()));
    }

    public static String filePathToTemplatePath(String path) {
        return path.replaceAll(Pattern.quote(File.separator), TEMPLATE_PATH_SEPARATOR);
    }

    public static String classNameToFilePath(String className) {
        StringBuilder sb = new StringBuilder(File.separator);
        sb.append(className);
        for (int i = File.separator.length(); i < sb.length(); ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.replace(i, i + 1, File.separator);
        }
        return sb.toString();
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(HEXCHARS[(bytes[i] & 0xF0) >> 4]);
            buffer.append(HEXCHARS[bytes[i] & 0xF]);
        }
        return buffer.toString();
    }

    public static String hexify4(int integer) {
        int i;
        String s = Integer.toHexString(i);
        int pad = 3;
        for (i = integer; i > 16; i /= 16) {
            --pad;
        }
        return "000".substring(0, pad) + s;
    }

    public static void commaJoin(StringBuilder builder, Iterable<String> iterable) {
        boolean seenElement = false;
        for (String element : iterable) {
            if (seenElement) {
                builder.append(", ");
            } else {
                seenElement = true;
            }
            builder.append(element);
        }
    }
}

