/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteBufPayload
implements Payload {
    private static final Logger log = LoggerFactory.getLogger(ByteBufPayload.class);
    public static boolean POOL_ENABLED = Boolean.getBoolean("jetlinks.eventbus.payload.pool.enabled");
    private static final Recycler<ByteBufPayload> RECYCLER = new Recycler<ByteBufPayload>(){

        protected ByteBufPayload newObject(Recycler.Handle<ByteBufPayload> handle) {
            return new ByteBufPayload(handle);
        }
    };
    private final Recycler.Handle<ByteBufPayload> handle;
    private ByteBuf body;
    private String caller;

    ByteBufPayload(Recycler.Handle<ByteBufPayload> handle) {
        this.handle = handle;
    }

    static Payload of(ByteBuf body) {
        ByteBufPayload payload;
        if (POOL_ENABLED) {
            try {
                payload = (ByteBufPayload)RECYCLER.get();
            }
            catch (Exception e) {
                payload = new ByteBufPayload(null);
            }
        } else {
            payload = new ByteBufPayload(null);
        }
        if (log.isTraceEnabled()) {
            for (StackTraceElement element : new Exception().getStackTrace()) {
                if ("org.jetlinks.core.Payload".equals(element.getClassName()) || "org.jetlinks.core.ByteBufPayload".equals(element.getClassName()) || element.getClassName().startsWith("org.jetlinks.core.codec")) continue;
                payload.caller = element.toString();
                break;
            }
        }
        payload.body = body;
        return payload;
    }

    @Override
    public boolean release() {
        return this.handleRelease(ReferenceCountUtil.release((Object)this.body));
    }

    @Override
    public boolean release(int dec) {
        return this.handleRelease(ReferenceCountUtil.release((Object)this.body, (int)dec));
    }

    @Override
    public Payload retain(int inc) {
        ReferenceCountUtil.retain((Object)this.body, (int)inc);
        return this;
    }

    @Override
    public Payload retain() {
        ReferenceCountUtil.retain((Object)this.body);
        return this;
    }

    @Override
    @Nonnull
    public ByteBuf getBody() {
        return this.body;
    }

    protected boolean handleRelease(boolean release) {
        if (release && this.handle != null) {
            this.body = null;
            this.caller = null;
            this.handle.recycle((Object)this);
        }
        return release;
    }

    protected void finalize() throws Throwable {
        int refCnt = ReferenceCountUtil.refCnt((Object)this.body);
        if (refCnt > 0) {
            log.trace("payload {} was not release properly, release() was not called before it's garbage-collected. refCnt={}. caller: {}", new Object[]{this.body, refCnt, this.caller});
        }
        super.finalize();
    }

    public String toString() {
        return "ByteBufPayload{body=" + this.body + ", caller='" + this.caller + '\'' + '}';
    }
}

