/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.codec.Encoder;
import org.jetlinks.core.metadata.Jsonable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativePayload<T>
extends AbstractReferenceCounted
implements Payload {
    private static final Logger log = LoggerFactory.getLogger(NativePayload.class);
    private T nativeObject;
    private Encoder<T> encoder;
    private volatile Payload ref;
    private ByteBuf buf;
    private static Recycler<NativePayload> POOL = new Recycler<NativePayload>(){

        protected NativePayload newObject(Recycler.Handle<NativePayload> handle) {
            return new NativePayload(handle);
        }
    };
    private final Recycler.Handle<NativePayload> handle;

    private NativePayload(Recycler.Handle<NativePayload> handle) {
        this.handle = handle;
    }

    @Override
    public Payload slice() {
        return this.ref != null ? this.ref.slice() : this;
    }

    public static <T> NativePayload<T> of(T nativeObject, Encoder<T> encoder) {
        NativePayload<T> payload;
        try {
            payload = (NativePayload<T>)POOL.get();
        }
        catch (Exception e) {
            payload = new NativePayload<T>(null);
        }
        payload.setRefCnt(1);
        payload.nativeObject = nativeObject;
        payload.encoder = encoder;
        return payload;
    }

    public static <T> NativePayload<T> of(T nativeObject, Supplier<Payload> bodySupplier) {
        return NativePayload.of(nativeObject, (T v) -> (Payload)bodySupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T decode(Decoder<T> decoder, boolean release) {
        try {
            if (decoder.isDecodeFrom(this.nativeObject)) {
                T t = this.nativeObject;
                return t;
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
        Class<T> type = decoder.forType();
        if (type == JSONObject.class) return (T)this.bodyToJson(release);
        if (type == Map.class) {
            return (T)this.bodyToJson(release);
        }
        if (!Map.class.isAssignableFrom(decoder.forType())) return Payload.super.decode(decoder, release);
        return (T)this.bodyToJson(release).toJavaObject(decoder.forType());
    }

    @Override
    public Object decode() {
        return this.decode(true);
    }

    @Override
    public Object decode(boolean release) {
        try {
            T t = this.nativeObject;
            return t;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ByteBuf getBody() {
        if (this.buf == null) {
            NativePayload nativePayload = this;
            synchronized (nativePayload) {
                if (this.buf != null) {
                    return this.buf;
                }
                this.ref = this.encoder.encode(this.nativeObject);
                this.buf = Unpooled.unreleasableBuffer((ByteBuf)this.ref.getBody());
            }
        }
        return this.buf;
    }

    @Override
    public int refCnt() {
        return super.refCnt();
    }

    protected void deallocate() {
        this.buf = null;
        this.nativeObject = null;
        this.encoder = null;
        if (this.ref != null) {
            ReferenceCountUtil.safeRelease((Object)this.ref);
            this.ref = null;
        }
        if (this.handle != null) {
            this.handle.recycle((Object)this);
        }
    }

    @Override
    public NativePayload<T> touch(Object o) {
        return this;
    }

    @Override
    public NativePayload<T> touch() {
        super.touch();
        return this;
    }

    @Override
    public NativePayload<T> retain() {
        return this.retain(1);
    }

    @Override
    public NativePayload<T> retain(int inc) {
        super.retain(inc);
        return this;
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        return super.release(decrement);
    }

    @Override
    public String bodyToString(boolean release) {
        try {
            String string = this.nativeObject.toString();
            return string;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONArray bodyToJsonArray(boolean release) {
        try {
            List<Object> collection;
            if (this.nativeObject == null) {
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            if (this.nativeObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)this.nativeObject;
                return jSONArray;
            }
            if (this.nativeObject instanceof List) {
                collection = (ArrayList)this.nativeObject;
            } else if (this.nativeObject instanceof Collection) {
                collection = new ArrayList((Collection)this.nativeObject);
            } else if (this.nativeObject instanceof Object[]) {
                collection = Arrays.asList((Object[])this.nativeObject);
            } else {
                throw new UnsupportedOperationException("body is not arry");
            }
            JSONArray jSONArray = new JSONArray((List)collection);
            return jSONArray;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    @Override
    public JSONObject bodyToJson(boolean release) {
        try {
            if (this.nativeObject == null) {
                JSONObject jSONObject = new JSONObject();
                return jSONObject;
            }
            if (this.nativeObject instanceof Jsonable) {
                JSONObject jSONObject = ((Jsonable)this.nativeObject).toJson();
                return jSONObject;
            }
            JSONObject jSONObject = (JSONObject)FastBeanCopier.copy(this.nativeObject, JSONObject::new, (String[])new String[0]);
            return jSONObject;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    public String toString() {
        return this.nativeObject == null ? "null" : this.nativeObject.toString();
    }

    protected void finalize() throws Throwable {
        if (this.refCnt() > 0) {
            log.warn("payload {} was not release properly, release() was not called before it's garbage-collected. refCnt={}", this.nativeObject, (Object)this.refCnt());
        }
        super.finalize();
    }

    public T getNativeObject() {
        return this.nativeObject;
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    public Payload getRef() {
        return this.ref;
    }

    public ByteBuf getBuf() {
        return this.buf;
    }

    public Recycler.Handle<NativePayload> getHandle() {
        return this.handle;
    }

    public void setNativeObject(T nativeObject) {
        this.nativeObject = nativeObject;
    }

    public void setEncoder(Encoder<T> encoder) {
        this.encoder = encoder;
    }

    public void setRef(Payload ref) {
        this.ref = ref;
    }

    public void setBuf(ByteBuf buf) {
        this.buf = buf;
    }
}

