/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;

class SimpleValues
implements Values {
    @NonNull
    private final Map<String, Object> values;

    @Override
    public Map<String, Object> getAllValues() {
        return new HashMap<String, Object>(this.values);
    }

    @Override
    public Optional<Value> getValue(String key) {
        return Optional.ofNullable(key).map(this.values::get).map(Value::simple);
    }

    @Override
    public Values merge(Values source) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(this.values);
        merged.putAll(source.getAllValues());
        return Values.of(merged);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Set<String> getNonExistentKeys(Collection<String> keys) {
        return keys.stream().filter(has -> !this.values.containsKey(has)).collect(Collectors.toSet());
    }

    @Override
    public String getString(String key, Supplier<String> defaultValue) {
        if (MapUtils.isEmpty(this.values)) {
            return defaultValue.get();
        }
        Object val = this.values.get(key);
        if (val == null) {
            return defaultValue.get();
        }
        return String.valueOf(val);
    }

    @Override
    public Number getNumber(String key, Supplier<Number> defaultValue) {
        if (MapUtils.isEmpty(this.values)) {
            return defaultValue.get();
        }
        Object val = this.values.get(key);
        if (val == null) {
            return defaultValue.get();
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        return (Number)FastBeanCopier.DEFAULT_CONVERT.convert(val, Number.class, FastBeanCopier.EMPTY_CLASS_ARRAY);
    }

    @ConstructorProperties(value={"values"})
    private SimpleValues(@NonNull Map<String, Object> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.values = values;
    }

    public static SimpleValues of(@NonNull Map<String, Object> values) {
        return new SimpleValues(values);
    }
}

