/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;

public class ErrorCodec
implements Codec<Throwable> {
    public static ErrorCodec RUNTIME;
    public static ErrorCodec DEFAULT;
    Function<String, Throwable> mapping;

    public static ErrorCodec of(Function<String, Throwable> mapping) {
        return new ErrorCodec(mapping);
    }

    @Override
    public Class<Throwable> forType() {
        return Throwable.class;
    }

    @Override
    public Throwable decode(@Nonnull Payload payload) {
        return this.mapping.apply(payload.bodyToString(false));
    }

    @Override
    public Payload encode(Throwable body) {
        String message = body.getMessage() == null ? body.getClass().getSimpleName() : body.getMessage();
        return Payload.of(message);
    }

    @ConstructorProperties(value={"mapping"})
    private ErrorCodec(Function<String, Throwable> mapping) {
        this.mapping = mapping;
    }

    static {
        DEFAULT = RUNTIME = ErrorCodec.of(RuntimeException::new);
    }
}

