/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.config;

import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.config.SimpleConfigKey;

public interface ConfigKey<V> {
    public String getKey();

    default public String getName() {
        return this.getKey();
    }

    default public Class<V> getType() {
        return Object.class;
    }

    public static <T> ConfigKey<T> of(String key) {
        return ConfigKey.of(key, key);
    }

    public static <T> ConfigKey<T> of(String key, String name) {
        return SimpleConfigKey.of(key, name, Object.class);
    }

    public static <T> ConfigKey<T> of(String key, String name, Class<T> type) {
        return SimpleConfigKey.of(key, name, type);
    }

    default public ConfigKeyValue<V> value(final V value) {
        return new ConfigKeyValue<V>(){

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public String getKey() {
                return ConfigKey.this.getKey();
            }

            @Override
            public String getName() {
                return ConfigKey.this.getName();
            }

            @Override
            public Class<V> getType() {
                return ConfigKey.this.getType();
            }
        };
    }
}

