/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.config.StorageConfigurable;
import org.jetlinks.core.defaults.DefaultDeviceMessageSender;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceMessageSender;
import org.jetlinks.core.device.DeviceOperationBroker;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.device.DeviceStateInfo;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.utils.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class DefaultDeviceOperator
implements DeviceOperator,
StorageConfigurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceOperator.class);
    public static final DeviceStateChecker DEFAULT_STATE_CHECKER = device -> DefaultDeviceOperator.checkState0((DefaultDeviceOperator)device);
    private static final ConfigKey<Long> lastMetadataTimeKey = ConfigKey.of("lst_metadata_time");
    private static final AtomicReferenceFieldUpdater<DefaultDeviceOperator, DeviceMetadata> METADATA_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultDeviceOperator.class, DeviceMetadata.class, "metadataCache");
    private static final AtomicLongFieldUpdater<DefaultDeviceOperator> METADATA_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(DefaultDeviceOperator.class, "lastMetadataTime");
    private final String id;
    private final DeviceOperationBroker handler;
    private final DeviceRegistry registry;
    private final DeviceMessageSender messageSender;
    private final Mono<ConfigStorage> storageMono;
    private final Mono<ProtocolSupport> protocolSupportMono;
    private final Mono<DeviceMetadata> metadataMono;
    private final DeviceStateChecker stateChecker;
    private volatile long lastMetadataTime = -1L;
    private volatile DeviceMetadata metadataCache;

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry) {
        this(id, supports, storageManager, handler, registry, DeviceMessageSenderInterceptor.DO_NOTING);
    }

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry, DeviceMessageSenderInterceptor interceptor) {
        this(id, supports, storageManager, handler, registry, interceptor, DEFAULT_STATE_CHECKER);
    }

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry, DeviceMessageSenderInterceptor interceptor, DeviceStateChecker deviceStateChecker) {
        this.id = id;
        this.registry = registry;
        this.handler = handler;
        this.messageSender = new DefaultDeviceMessageSender(handler, this, registry, interceptor);
        this.storageMono = storageManager.getStorage("device:" + id);
        this.protocolSupportMono = this.getProduct().flatMap(DeviceProductOperator::getProtocol);
        this.stateChecker = deviceStateChecker;
        this.metadataMono = this.getSelfConfig(lastMetadataTimeKey).flatMap(i -> {
            if (i.equals(this.lastMetadataTime) && this.metadataCache != null) {
                return Mono.just((Object)this.metadataCache);
            }
            METADATA_TIME_UPDATER.set(this, (long)i);
            return Mono.zip(this.getSelfConfig(DeviceConfigKey.metadata), this.protocolSupportMono).flatMap(tp2 -> ((ProtocolSupport)tp2.getT2()).getMetadataCodec().decode((String)tp2.getT1()).doOnNext(metadata -> METADATA_UPDATER.set(this, (DeviceMetadata)metadata)));
        }).switchIfEmpty(this.getParent().flatMap(DeviceProductOperator::getMetadata));
    }

    @Override
    public Mono<ConfigStorage> getReactiveStorage() {
        return this.storageMono;
    }

    @Override
    public String getDeviceId() {
        return this.id;
    }

    @Override
    public Mono<String> getConnectionServerId() {
        return this.getSelfConfig(DeviceConfigKey.connectionServerId.getKey()).map(Value::asString);
    }

    @Override
    public Mono<String> getSessionId() {
        return this.getSelfConfig(DeviceConfigKey.sessionId.getKey()).map(Value::asString);
    }

    @Override
    public Mono<String> getAddress() {
        return this.getConfig("address").map(Value::asString);
    }

    @Override
    public Mono<Void> setAddress(String address) {
        return this.setConfig("address", address).then();
    }

    @Override
    public Mono<Boolean> putState(byte state) {
        return this.setConfig("state", (Object)state);
    }

    @Override
    public Mono<Byte> getState() {
        return this.getSelfConfigs(Arrays.asList("state", DeviceConfigKey.parentGatewayId.getKey(), DeviceConfigKey.selfManageState.getKey())).flatMap(values -> {
            Byte state = values.getValue("state").map(val -> val.as(Byte.class)).orElse((byte)0);
            boolean isSelfManageState = values.getValue(DeviceConfigKey.selfManageState.getKey()).map(val -> val.as(Boolean.class)).orElse(false);
            if (isSelfManageState) {
                return Mono.just((Object)state);
            }
            String parentGatewayId = values.getValue(DeviceConfigKey.parentGatewayId).orElse(null);
            if (!state.equals((byte)1) && StringUtils.hasText((String)parentGatewayId)) {
                return this.registry.getDevice(parentGatewayId).flatMap(DeviceOperator::getState);
            }
            return Mono.just((Object)state);
        }).defaultIfEmpty((Object)0);
    }

    private Mono<Byte> doCheckState() {
        return Mono.defer(() -> this.getSelfConfigs(Arrays.asList(DeviceConfigKey.connectionServerId.getKey(), DeviceConfigKey.parentGatewayId.getKey(), DeviceConfigKey.selfManageState.getKey(), "state")).flatMap(values -> {
            String server = values.getValue(DeviceConfigKey.connectionServerId).orElse(null);
            Byte state = values.getValue("state").map(val -> val.as(Byte.class)).orElse((byte)0);
            if (StringUtils.hasText((String)server)) {
                return this.handler.getDeviceState(server, Collections.singletonList(this.id)).map(DeviceStateInfo::getState).singleOrEmpty().timeout(Duration.ofSeconds(1L), Mono.just((Object)state)).defaultIfEmpty((Object)state);
            }
            if (values.getValue(DeviceConfigKey.selfManageState).orElse(false).booleanValue()) {
                return Mono.just((Object)state);
            }
            String parentGatewayId = values.getValue(DeviceConfigKey.parentGatewayId).orElse(null);
            if (StringUtils.hasText((String)parentGatewayId)) {
                return this.registry.getDevice(parentGatewayId).flatMap(device -> device.messageSender().send(ChildDeviceMessage.create(parentGatewayId, DeviceStateCheckMessage.create(this.getDeviceId()))).singleOrEmpty().map(msg -> {
                    if (msg.getChildDeviceMessage() instanceof DeviceStateCheckMessageReply) {
                        return ((DeviceStateCheckMessageReply)msg.getChildDeviceMessage()).getState();
                    }
                    log.warn("\u5b50\u8bbe\u5907\u72b6\u6001\u68c0\u67e5\u8fd4\u56de\u6d88\u606f\u9519\u8bef{}", msg);
                    return (byte)1;
                }).onErrorResume(err -> device.checkState()));
            }
            if (state.equals((byte)1)) {
                return Mono.just((Object)-1);
            }
            return Mono.just((Object)state);
        }));
    }

    @Override
    public Mono<Byte> checkState() {
        return Mono.zip((Mono)this.stateChecker.checkState(this).switchIfEmpty(Mono.defer(() -> DEFAULT_STATE_CHECKER.checkState(this))).defaultIfEmpty((Object)1), this.getState()).flatMap(tp2 -> {
            byte old;
            byte newer = (Byte)tp2.getT1();
            if (newer != (old = ((Byte)tp2.getT2()).byteValue())) {
                log.info("device[{}] state changed from {} to {}", new Object[]{this.getDeviceId(), old, newer});
                HashMap<String, Object> configs = new HashMap<String, Object>();
                configs.put("state", newer);
                if (newer == 1) {
                    configs.put("onlineTime", System.currentTimeMillis());
                } else if (newer == -1) {
                    configs.put("offlineTime", System.currentTimeMillis());
                }
                return this.setConfigs(configs).thenReturn((Object)newer);
            }
            return Mono.just((Object)newer);
        });
    }

    @Override
    public Mono<Long> getOnlineTime() {
        return this.getSelfConfig("onlineTime").map(val -> val.as(Long.class)).switchIfEmpty(Mono.defer(() -> this.getSelfConfig(DeviceConfigKey.parentGatewayId).flatMap(this.registry::getDevice).flatMap(DeviceOperator::getOnlineTime)));
    }

    @Override
    public Mono<Long> getOfflineTime() {
        return this.getSelfConfig("offlineTime").map(val -> val.as(Long.class)).switchIfEmpty(Mono.defer(() -> this.getSelfConfig(DeviceConfigKey.parentGatewayId).flatMap(this.registry::getDevice).flatMap(DeviceOperator::getOfflineTime)));
    }

    @Override
    public Mono<Boolean> offline() {
        return this.setConfigs(DeviceConfigKey.connectionServerId.value(""), DeviceConfigKey.sessionId.value(""), ConfigKey.of("offlineTime").value(System.currentTimeMillis()), ConfigKey.of("state").value((byte)-1)).doOnError(err -> log.error("offline device error", err));
    }

    @Override
    public Mono<Boolean> online(String serverId, String sessionId, String address) {
        return this.setConfigs(DeviceConfigKey.connectionServerId.value(serverId), DeviceConfigKey.sessionId.value(sessionId), ConfigKey.of("address").value(address), ConfigKey.of("onlineTime").value(System.currentTimeMillis()), ConfigKey.of("state").value((byte)1)).doOnError(err -> log.error("online device error", err));
    }

    @Override
    public Mono<Value> getSelfConfig(String key) {
        return this.getConfig(key, false);
    }

    @Override
    public Mono<Values> getSelfConfigs(Collection<String> keys) {
        return this.getConfigs(keys, false);
    }

    @Override
    public Mono<Boolean> disconnect() {
        DisconnectDeviceMessage disconnect = new DisconnectDeviceMessage();
        disconnect.setDeviceId(this.getDeviceId());
        disconnect.setMessageId(IdUtils.newUUID());
        return this.messageSender().send(Mono.just((Object)disconnect)).next().map(DeviceMessageReply::isSuccess);
    }

    @Override
    public Mono<AuthenticationResponse> authenticate(AuthenticationRequest request) {
        return this.getProtocol().flatMap(protocolSupport -> protocolSupport.authenticate(request, this));
    }

    @Override
    public Mono<DeviceMetadata> getMetadata() {
        return this.metadataMono;
    }

    public Mono<DeviceProductOperator> getParent() {
        return this.getReactiveStorage().flatMap(store -> store.getConfig(DeviceConfigKey.productId.getKey())).map(Value::asString).flatMap(this.registry::getProduct);
    }

    @Override
    public Mono<ProtocolSupport> getProtocol() {
        return this.protocolSupportMono;
    }

    @Override
    public Mono<DeviceProductOperator> getProduct() {
        return this.getParent();
    }

    @Override
    public DeviceMessageSender messageSender() {
        return this.messageSender;
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(DeviceConfigKey.metadata.getKey(), metadata);
        return this.setConfigs(configs);
    }

    @Override
    public Mono<Void> resetMetadata() {
        METADATA_UPDATER.set(this, null);
        METADATA_TIME_UPDATER.set(this, -1L);
        return this.removeConfigs(DeviceConfigKey.metadata, lastMetadataTimeKey).then(this.getProtocol().flatMap(support -> support.onDeviceMetadataChanged(this)));
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        HashMap<String, Object> configs = new HashMap<String, Object>(conf);
        if (conf.containsKey(DeviceConfigKey.metadata.getKey())) {
            this.lastMetadataTime = System.currentTimeMillis();
            configs.put(lastMetadataTimeKey.getKey(), this.lastMetadataTime);
            return StorageConfigurable.super.setConfigs(configs).doOnNext(suc -> {
                this.metadataCache = null;
            }).then(this.getProtocol().flatMap(support -> support.onDeviceMetadataChanged(this))).thenReturn((Object)true);
        }
        return StorageConfigurable.super.setConfigs(configs);
    }

    private static Mono<Byte> checkState0(DefaultDeviceOperator operator) {
        return operator.getProtocol().flatMap(ProtocolSupport::getStateChecker).flatMap(deviceStateChecker -> deviceStateChecker.checkState(operator)).switchIfEmpty(operator.doCheckState());
    }
}

