/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.FunctionInvokeMessageSender;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.exception.FunctionUndefinedException;
import org.jetlinks.core.message.exception.IllegalParameterException;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.utils.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultFunctionInvokeMessageSender
implements FunctionInvokeMessageSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultFunctionInvokeMessageSender.class);
    private FunctionInvokeMessage message = new FunctionInvokeMessage();
    private DeviceOperator operator;

    public DefaultFunctionInvokeMessageSender(DeviceOperator operator, String functionId) {
        this.operator = operator;
        this.message.setMessageId(IdUtils.newUUID());
        this.message.setFunctionId(functionId);
        this.message.setDeviceId(operator.getDeviceId());
    }

    @Override
    public FunctionInvokeMessageSender custom(Consumer<FunctionInvokeMessage> messageConsumer) {
        messageConsumer.accept(this.message);
        return this;
    }

    @Override
    public FunctionInvokeMessageSender addParameter(FunctionParameter parameter) {
        this.message.addInput(parameter);
        return this;
    }

    @Override
    public FunctionInvokeMessageSender setParameter(List<FunctionParameter> parameter) {
        this.message.setInputs(new ArrayList<FunctionParameter>(parameter));
        return this;
    }

    @Override
    public FunctionInvokeMessageSender messageId(String messageId) {
        this.message.setMessageId(messageId);
        return this;
    }

    @Override
    public FunctionInvokeMessageSender header(String header, Object value) {
        this.message.addHeader(header, value);
        return this;
    }

    @Override
    public Mono<FunctionInvokeMessageSender> validate() {
        String function = this.message.getFunctionId();
        return this.operator.getMetadata().flatMap(metadata -> Mono.justOrEmpty(metadata.getFunction(function))).switchIfEmpty(Mono.error(() -> new FunctionUndefinedException(function, "\u529f\u80fd[" + function + "]\u672a\u5b9a\u4e49"))).doOnNext(functionMetadata -> {
            List<PropertyMetadata> metadataInputs = functionMetadata.getInputs();
            List<FunctionParameter> inputs = this.message.getInputs();
            Map properties = inputs.stream().collect(Collectors.toMap(FunctionParameter::getName, Function.identity(), (t1, t2) -> t1));
            for (PropertyMetadata metadata : metadataInputs) {
                FunctionParameter parameter = (FunctionParameter)properties.get(metadata.getId());
                Object value = Optional.ofNullable(parameter).map(FunctionParameter::getValue).orElse(null);
                if (value == null) continue;
                ValidateResult validateResult = metadata.getValueType().validate(value);
                validateResult.ifFail(result -> {
                    throw new IllegalParameterException(metadata.getId(), result.getErrorMsg());
                });
                if (validateResult.getValue() == null) continue;
                parameter.setValue(validateResult.getValue());
            }
        }).thenReturn((Object)this);
    }

    @Override
    public Flux<FunctionInvokeMessageReply> send() {
        if (this.message.getHeader(Headers.async).isPresent()) {
            return this.doSend();
        }
        return this.operator.getMetadata().flatMap(meta -> Mono.justOrEmpty(meta.getFunction(this.message.getFunctionId()))).doOnNext(func -> this.async(func.isAsync())).thenMany(this.doSend());
    }

    private Flux<FunctionInvokeMessageReply> doSend() {
        return this.operator.messageSender().send(Mono.just((Object)this.message));
    }
}

