/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.ReadPropertyMessageSender;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.utils.IdUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReadPropertyMessageSender
implements ReadPropertyMessageSender {
    private ReadPropertyMessage message = new ReadPropertyMessage();
    private DeviceOperator operator;

    public DefaultReadPropertyMessageSender(DeviceOperator operator) {
        this.operator = operator;
        this.message.setMessageId(IdUtils.newUUID());
        this.message.setDeviceId(operator.getDeviceId());
    }

    @Override
    public ReadPropertyMessageSender read(Collection<String> property) {
        this.message.setProperties(new ArrayList<String>(property));
        return this;
    }

    @Override
    public ReadPropertyMessageSender custom(Consumer<ReadPropertyMessage> messageConsumer) {
        messageConsumer.accept(this.message);
        return this;
    }

    @Override
    public ReadPropertyMessageSender header(String header, Object value) {
        this.message.addHeader(header, value);
        return this;
    }

    @Override
    public ReadPropertyMessageSender messageId(String messageId) {
        this.message.setMessageId(messageId);
        return this;
    }

    @Override
    public Flux<ReadPropertyMessageReply> send() {
        return this.operator.messageSender().send(Mono.just((Object)this.message));
    }
}

