/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetlinks.core.Configurable;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceMessageSender;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.metadata.DeviceMetadata;
import reactor.core.publisher.Mono;

public interface DeviceOperator
extends Configurable {
    public String getDeviceId();

    public Mono<String> getConnectionServerId();

    public Mono<String> getSessionId();

    public Mono<String> getAddress();

    public Mono<Void> setAddress(String var1);

    public Mono<Boolean> putState(byte var1);

    public Mono<Byte> getState();

    public Mono<Byte> checkState();

    public Mono<Long> getOnlineTime();

    public Mono<Long> getOfflineTime();

    default public Mono<Boolean> online(String serverId, String sessionId) {
        return this.online(serverId, sessionId, null);
    }

    public Mono<Boolean> online(String var1, String var2, String var3);

    public Mono<Value> getSelfConfig(String var1);

    public Mono<Values> getSelfConfigs(Collection<String> var1);

    default public Mono<Values> getSelfConfigs(String ... keys) {
        return this.getSelfConfigs(Arrays.asList(keys));
    }

    default public <V> Mono<V> getSelfConfig(ConfigKey<V> key) {
        return this.getSelfConfig(key.getKey()).map(value -> value.as(key.getType()));
    }

    default public Mono<Values> getSelfConfigs(ConfigKey<?> ... keys) {
        return this.getSelfConfigs(Arrays.stream(keys).map(ConfigKey::getKey).collect(Collectors.toSet()));
    }

    default public Mono<Boolean> isOnline() {
        return this.checkState().map(state -> state.equals((byte)1)).defaultIfEmpty((Object)false);
    }

    public Mono<Boolean> offline();

    public Mono<Boolean> disconnect();

    public Mono<AuthenticationResponse> authenticate(AuthenticationRequest var1);

    public Mono<DeviceMetadata> getMetadata();

    public Mono<ProtocolSupport> getProtocol();

    public DeviceMessageSender messageSender();

    public Mono<Boolean> updateMetadata(String var1);

    public Mono<Void> resetMetadata();

    public Mono<DeviceProductOperator> getProduct();
}

