/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.enums;

import java.beans.ConstructorProperties;
import java.util.Optional;

public enum ErrorCode {
    REQUEST_HANDLING("\u8bf7\u6c42\u5904\u7406\u4e2d"),
    CLIENT_OFFLINE("\u8bbe\u5907\u672a\u5728\u7ebf"),
    CONNECTION_LOST("\u8bbe\u5907\u8fde\u63a5\u5df2\u4e22\u5931"),
    NO_REPLY("\u8bbe\u5907\u672a\u56de\u590d"),
    TIME_OUT("\u8d85\u65f6"),
    SYSTEM_ERROR("\u7cfb\u7edf\u9519\u8bef"),
    UNSUPPORTED_MESSAGE("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c"),
    PARAMETER_ERROR("\u53c2\u6570\u9519\u8bef"),
    PARAMETER_UNDEFINED("\u53c2\u6570\u672a\u5b9a\u4e49"),
    FUNCTION_UNDEFINED("\u529f\u80fd\u672a\u5b9a\u4e49"),
    PROPERTY_UNDEFINED("\u5c5e\u6027\u672a\u5b9a\u4e49"),
    UNKNOWN_PARENT_DEVICE("\u672a\u77e5\u7684\u7236\u8bbe\u5907"),
    CYCLIC_DEPENDENCE("\u5faa\u73af\u4f9d\u8d56"),
    SERVER_NOT_AVAILABLE("\u670d\u52a1\u4e0d\u53ef\u7528"),
    UNKNOWN("\u672a\u77e5\u9519\u8bef");

    private final String text;

    public static Optional<ErrorCode> of(String code) {
        if (code == null) {
            return Optional.empty();
        }
        for (ErrorCode value : ErrorCode.values()) {
            if (!value.name().equalsIgnoreCase(code)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String getText() {
        return this.text;
    }

    @ConstructorProperties(value={"text"})
    private ErrorCode(String text) {
        this.text = text;
    }
}

