/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.util.Assert;

public class Subscription
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Feature[] DEFAULT_FEATURES = Feature.values();
    private final String subscriber;
    private final String[] topics;
    private final Feature[] features;
    private Runnable doOnSubscribe;

    public static Subscription of(String subscriber, String ... topic) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).build();
    }

    public static Subscription of(String subscriber, String[] topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public static Subscription of(String subscriber, String topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public Subscription copy(Feature ... newFeatures) {
        return new Subscription(this.subscriber, this.topics, newFeatures, null);
    }

    public Subscription onSubscribe(Runnable sub) {
        this.doOnSubscribe = sub;
        return this;
    }

    public boolean hasFeature(Feature feature) {
        return feature.in(this.features);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"subscriber", "topics", "features", "doOnSubscribe"})
    public Subscription(String subscriber, String[] topics, Feature[] features, Runnable doOnSubscribe) {
        this.subscriber = subscriber;
        this.topics = topics;
        this.features = features;
        this.doOnSubscribe = doOnSubscribe;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public Runnable getDoOnSubscribe() {
        return this.doOnSubscribe;
    }

    public static class Builder {
        private String subscriber;
        private final Set<String> topics = new HashSet<String>();
        private final Set<Feature> features = new HashSet<Feature>();
        private Runnable doOnSubscribe;

        public Builder randomSubscriberId() {
            return this.subscriberId(UUID.randomUUID().toString());
        }

        public Builder subscriberId(String id) {
            this.subscriber = id;
            return this;
        }

        public Builder topics(String ... topics) {
            return this.topics(Arrays.asList(topics));
        }

        public Builder topics(Collection<String> topics) {
            this.topics.addAll(topics.stream().flatMap(topic -> TopicUtils.expand(topic).stream()).collect(Collectors.toSet()));
            return this;
        }

        public Builder features(Feature ... features) {
            this.features.addAll(Arrays.asList(features));
            return this;
        }

        public Builder doOnSubscribe(Runnable runnable) {
            this.doOnSubscribe = runnable;
            return this;
        }

        public Builder justLocal() {
            this.features.clear();
            return this.features(Feature.local);
        }

        public Builder justBroker() {
            this.features.clear();
            return this.features(Feature.broker);
        }

        public Builder local() {
            return this.features(Feature.local);
        }

        public Builder broker() {
            return this.features(Feature.broker);
        }

        public Builder shared() {
            return this.features(Feature.shared);
        }

        public Subscription build() {
            if (this.features.isEmpty()) {
                this.local();
            }
            Assert.notEmpty(this.topics, (String)"topic cannot be empty");
            Assert.hasText((String)this.subscriber, (String)"subscriber cannot be empty");
            return new Subscription(this.subscriber, this.topics.toArray(new String[0]), this.features.toArray(new Feature[0]), this.doOnSubscribe);
        }
    }

    @Dict(value="subscription-feature")
    public static enum Feature implements EnumDict<String>
    {
        shared("shared"),
        local("\u8ba2\u9605\u672c\u5730\u6d88\u606f"),
        broker("\u8ba2\u9605\u4ee3\u7406\u6d88\u606f");

        private final String text;

        public String getValue() {
            return this.name();
        }

        @ConstructorProperties(value={"text"})
        private Feature(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

