/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.utils.TopicUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPayload
implements Payload {
    private static final Logger log = LoggerFactory.getLogger(TopicPayload.class);
    public static boolean POOL_ENABLED = Boolean.getBoolean("jetlinks.eventbus.payload.pool.enabled");
    public static Recycler<TopicPayload> RECYCLER = new Recycler<TopicPayload>(){

        protected TopicPayload newObject(Recycler.Handle<TopicPayload> handle) {
            return new TopicPayload(handle);
        }
    };
    private String topic;
    private Payload payload;
    private final Recycler.Handle<TopicPayload> handle;

    private TopicPayload(Recycler.Handle<TopicPayload> handle) {
        this.handle = handle;
    }

    public static TopicPayload of(String topic, Payload payload) {
        if (POOL_ENABLED) {
            try {
                TopicPayload topicPayload = (TopicPayload)RECYCLER.get();
                topicPayload.topic = topic;
                topicPayload.payload = payload;
                return topicPayload;
            }
            catch (Exception e) {
                return TopicPayload.of(topic, payload, null);
            }
        }
        return TopicPayload.of(topic, payload, null);
    }

    @Override
    @Nonnull
    public ByteBuf getBody() {
        return this.payload.getBody();
    }

    @Override
    public TopicPayload slice() {
        return TopicPayload.of(this.topic, this.payload.slice());
    }

    @Override
    public boolean release() {
        return this.topic == null || this.handleRelease(ReferenceCountUtil.release((Object)this.payload));
    }

    @Override
    public boolean release(int dec) {
        return this.topic == null || this.handleRelease(ReferenceCountUtil.release((Object)this.payload, (int)dec));
    }

    protected void finalize() throws Throwable {
        if (this.handle != null && this.refCnt() != 0) {
            log.debug("topic [{}] payload was not release properly, release() was not called before it's garbage-collected. refCnt={}", (Object)this.toString(), (Object)this.refCnt());
        }
        super.finalize();
    }

    protected boolean handleRelease(boolean success) {
        if (success) {
            this.deallocate();
        }
        return success;
    }

    protected void deallocate() {
        if (this.handle != null) {
            this.payload = null;
            this.topic = null;
            this.handle.recycle((Object)this);
        }
    }

    @Override
    public TopicPayload retain() {
        this.payload.retain();
        return this;
    }

    @Override
    public TopicPayload retain(int inc) {
        this.payload.retain(inc);
        return this;
    }

    @Override
    public TopicPayload touch(Object o) {
        this.payload.touch(o);
        return this;
    }

    @Override
    public TopicPayload touch() {
        this.payload.touch();
        return this;
    }

    @Override
    public int refCnt() {
        return this.payload == null ? 0 : this.payload.refCnt();
    }

    public String toString() {
        return "{topic='" + this.topic + '\'' + ", payload=" + this.payload + '}';
    }

    @Override
    public JSONObject bodyToJson(boolean release) {
        return this.payload.bodyToJson(release);
    }

    @Override
    public JSONArray bodyToJsonArray(boolean release) {
        return this.payload.bodyToJsonArray(release);
    }

    @Override
    public String bodyToString() {
        return this.payload.bodyToString();
    }

    @Override
    public String bodyToString(boolean release) {
        return this.payload.bodyToString(release);
    }

    @Override
    public Object decode() {
        return this.payload.decode();
    }

    @Override
    public Object decode(boolean release) {
        return this.payload.decode(release);
    }

    @Override
    public <T> T decode(Class<T> decoder) {
        return this.payload.decode(decoder);
    }

    @Override
    public <T> T decode(Class<T> decoder, boolean release) {
        return this.payload.decode(decoder, release);
    }

    @Override
    public <T> T decode(Decoder<T> decoder) {
        return this.payload.decode(decoder);
    }

    @Override
    public <T> T decode(Decoder<T> decoder, boolean release) {
        return this.payload.decode(decoder, release);
    }

    public Map<String, String> getTopicVars(String pattern) {
        return TopicUtils.getPathVariables(pattern, this.getTopic());
    }

    public String getTopic() {
        return this.topic;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Recycler.Handle<TopicPayload> getHandle() {
        return this.handle;
    }

    @ConstructorProperties(value={"topic", "payload", "handle"})
    private TopicPayload(String topic, Payload payload, Recycler.Handle<TopicPayload> handle) {
        this.topic = topic;
        this.payload = payload;
        this.handle = handle;
    }

    public static TopicPayload of(String topic, Payload payload, Recycler.Handle<TopicPayload> handle) {
        return new TopicPayload(topic, payload, handle);
    }
}

