/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.ipc;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.ipc.IpcInvoker;
import org.jetlinks.core.ipc.IpcInvokerBuilder;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultIpcInvoker<REQ, RES>
implements IpcInvoker<REQ, RES> {
    private final String name;
    private final Function<Publisher<REQ>, Flux<RES>> channelRequester;
    private final Supplier<Flux<RES>> noArgStreamRequester;
    private final Function<REQ, Flux<RES>> streamRequester;
    private final Supplier<Mono<RES>> noArgRequester;
    private final Function<REQ, Mono<RES>> requester;
    private final Supplier<Mono<Void>> noArgFireAndForgetRequester;
    private final Function<REQ, Mono<Void>> fireAndForgetRequester;
    private final Disposable disposable;

    @Override
    public Flux<RES> requestChannel(Publisher<REQ> req) {
        if (this.channelRequester == null) {
            return IpcInvoker.super.requestChannel(req);
        }
        return this.channelRequester.apply(req);
    }

    @Override
    public Flux<RES> requestStream() {
        if (this.noArgStreamRequester == null) {
            return IpcInvoker.super.requestStream();
        }
        return this.noArgStreamRequester.get();
    }

    @Override
    public Flux<RES> requestStream(REQ req) {
        if (this.streamRequester == null) {
            return IpcInvoker.super.requestStream(req);
        }
        return this.streamRequester.apply(req);
    }

    @Override
    public Mono<RES> request() {
        if (this.noArgRequester == null) {
            return IpcInvoker.super.request();
        }
        return this.noArgRequester.get();
    }

    @Override
    public Mono<RES> request(REQ req) {
        if (this.requester == null) {
            return IpcInvoker.super.request(req);
        }
        return this.requester.apply(req);
    }

    @Override
    public Mono<Void> fireAndForget(REQ req) {
        if (this.fireAndForgetRequester == null) {
            return IpcInvoker.super.fireAndForget(req);
        }
        return this.fireAndForgetRequester.apply(req);
    }

    @Override
    public Mono<Void> fireAndForget() {
        if (this.noArgFireAndForgetRequester == null) {
            return IpcInvoker.super.fireAndForget();
        }
        return this.noArgFireAndForgetRequester.get();
    }

    @Override
    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    public IpcInvokerBuilder<REQ, RES> copyToBuilder() {
        return IpcInvokerBuilder.newBuilder().name(this.name).forRequestChannel(this.channelRequester).forRequestStream(this.streamRequester).forRequestStream(this.noArgStreamRequester).forRequest(this.requester).forRequest(this.noArgRequester).forFireAndForget(this.fireAndForgetRequester).forFireAndForget(this.noArgFireAndForgetRequester);
    }

    public String toString() {
        return "IpcInvoker{'" + this.name + '\'' + '}';
    }

    @ConstructorProperties(value={"name", "channelRequester", "noArgStreamRequester", "streamRequester", "noArgRequester", "requester", "noArgFireAndForgetRequester", "fireAndForgetRequester", "disposable"})
    public DefaultIpcInvoker(String name, Function<Publisher<REQ>, Flux<RES>> channelRequester, Supplier<Flux<RES>> noArgStreamRequester, Function<REQ, Flux<RES>> streamRequester, Supplier<Mono<RES>> noArgRequester, Function<REQ, Mono<RES>> requester, Supplier<Mono<Void>> noArgFireAndForgetRequester, Function<REQ, Mono<Void>> fireAndForgetRequester, Disposable disposable) {
        this.name = name;
        this.channelRequester = channelRequester;
        this.noArgStreamRequester = noArgStreamRequester;
        this.streamRequester = streamRequester;
        this.noArgRequester = noArgRequester;
        this.requester = requester;
        this.noArgFireAndForgetRequester = noArgFireAndForgetRequester;
        this.fireAndForgetRequester = fireAndForgetRequester;
        this.disposable = disposable;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

