/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.ipc;

import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.defaults.ErrorCodec;
import org.jetlinks.core.ipc.DefaultIpcDefinition;

public interface IpcDefinition<REQ, RES> {
    public String getAddress();

    public Codec<REQ> requestCodec();

    public Codec<RES> responseCodec();

    default public Codec<Throwable> errorCodec() {
        return ErrorCodec.DEFAULT;
    }

    public static <REQ, RES> IpcDefinition<REQ, RES> of(String address, Codec<REQ> requestCodec, Codec<RES> responseCodec) {
        return new DefaultIpcDefinition<REQ, RES>(address, requestCodec, responseCodec);
    }

    public static IpcDefinition<Void, Void> of(String address) {
        return new DefaultIpcDefinition<Void, Void>(address, Codecs.lookup(Void.class), Codecs.lookup(Void.class));
    }

    public static <REQ, RES> IpcDefinition<REQ, RES> of(String address, Class<REQ> requestType, Class<RES> responseType) {
        return new DefaultIpcDefinition<REQ, RES>(address, Codecs.lookup(requestType), Codecs.lookup(responseType));
    }
}

