/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.ipc;

import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.ipc.DefaultIpcInvokerBuilder;
import org.jetlinks.core.ipc.IpcInvoker;
import org.jetlinks.core.ipc.TimeoutIpcInvoker;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface IpcInvokerBuilder<REQ, RES> {
    public IpcInvokerBuilder<REQ, RES> name(String var1);

    public IpcInvokerBuilder<REQ, RES> forFireAndForget(Supplier<Mono<Void>> var1);

    public IpcInvokerBuilder<REQ, RES> forFireAndForget(Function<REQ, Mono<Void>> var1);

    public IpcInvokerBuilder<REQ, RES> forRequest(Supplier<Mono<RES>> var1);

    public IpcInvokerBuilder<REQ, RES> forRequest(Function<REQ, Mono<RES>> var1);

    public IpcInvokerBuilder<REQ, RES> forRequestStream(Function<REQ, Flux<RES>> var1);

    public IpcInvokerBuilder<REQ, RES> forRequestStream(Supplier<Flux<RES>> var1);

    public IpcInvokerBuilder<REQ, RES> forRequestChannel(Function<Publisher<REQ>, Flux<RES>> var1);

    public IpcInvokerBuilder<REQ, RES> doOnDispose(Disposable var1);

    public IpcInvokerBuilder<REQ, RES> timeout(Duration var1);

    public IpcInvoker<REQ, RES> build();

    public static <REQ, RES> IpcInvoker<REQ, RES> forTimeout(Duration timeout, IpcInvoker<REQ, RES> invoker) {
        return new TimeoutIpcInvoker<REQ, RES>(timeout, invoker);
    }

    public static <REQ, RES> IpcInvokerBuilder<REQ, RES> newBuilder() {
        return new DefaultIpcInvokerBuilder();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forFireAndForget(String name, Supplier<Mono<Void>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forFireAndForget(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forFireAndForget(String name, Function<REQ, Mono<Void>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forFireAndForget(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forRequest(String name, Supplier<Mono<RES>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forRequest(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forRequest(String name, Function<REQ, Mono<RES>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forRequest(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forRequestStream(String name, Function<REQ, Flux<RES>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forRequestStream(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forRequestStream(String name, Supplier<Flux<RES>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forRequestStream(requester).build();
    }

    public static <REQ, RES> IpcInvoker<REQ, RES> forRequestChannel(String name, Function<Publisher<REQ>, Flux<RES>> requester) {
        return IpcInvokerBuilder.newBuilder().name(name).forRequestChannel(requester).build();
    }
}

