/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.ipc;

import java.beans.ConstructorProperties;
import java.time.Duration;
import org.jetlinks.core.ipc.IpcCode;
import org.jetlinks.core.ipc.IpcException;
import org.jetlinks.core.ipc.IpcInvoker;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class TimeoutIpcInvoker<REQ, RES>
implements IpcInvoker<REQ, RES> {
    private final Duration timeout;
    private final IpcInvoker<REQ, RES> target;

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    public Mono<Void> fireAndForget() {
        return this.target.fireAndForget().timeout(this.timeout, Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Mono<Void> fireAndForget(REQ req) {
        return this.target.fireAndForget(req).timeout(this.timeout, Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Mono<RES> request() {
        return this.target.request().timeout(this.timeout, Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Mono<RES> request(REQ req) {
        return this.target.request(req).timeout(this.timeout, Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Flux<RES> requestStream() {
        return this.target.requestStream().timeout(this.timeout, (Publisher)Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Flux<RES> requestStream(REQ req) {
        return this.target.requestStream(req).timeout(this.timeout, (Publisher)Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public Flux<RES> requestChannel(Publisher<REQ> req) {
        return this.target.requestChannel(req).timeout(this.timeout, (Publisher)Mono.error(() -> new IpcException(IpcCode.timeout)));
    }

    @Override
    public void dispose() {
        this.target.dispose();
    }

    public boolean isDisposed() {
        return this.target.isDisposed();
    }

    @ConstructorProperties(value={"timeout", "target"})
    public TimeoutIpcInvoker(Duration timeout, IpcInvoker<REQ, RES> target) {
        this.timeout = timeout;
        this.target = target;
    }
}

