/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;

public class ChildDeviceMessage
extends CommonDeviceMessage
implements RepayableDeviceMessage<ChildDeviceMessageReply> {
    private String childDeviceId;
    private Message childDeviceMessage;

    public static ChildDeviceMessage create(String deviceId, DeviceMessage message) {
        ChildDeviceMessage msg = new ChildDeviceMessage();
        msg.setDeviceId(deviceId);
        msg.setMessageId(message.getMessageId());
        msg.setChildDeviceId(message.getDeviceId());
        msg.setChildDeviceMessage(message);
        return msg;
    }

    @Override
    public ChildDeviceMessageReply newReply() {
        ChildDeviceMessageReply reply = new ChildDeviceMessageReply();
        if (this.childDeviceMessage instanceof RepayableDeviceMessage) {
            reply.setChildDeviceMessage((Message)((RepayableDeviceMessage)this.childDeviceMessage).newReply());
        }
        reply.messageId(this.getMessageId());
        reply.deviceId(this.getDeviceId());
        reply.setChildDeviceId(this.getChildDeviceId());
        return reply;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        if (null != this.childDeviceMessage) {
            json.put("childDeviceMessage", (Object)this.childDeviceMessage.toJson());
        }
        return json;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.CHILD;
    }

    @Override
    public void validate() {
        if (this.childDeviceMessage instanceof ChildDeviceMessage) {
            HashSet<String> deviceId = new HashSet<String>();
            Message msg = this.childDeviceMessage;
            do {
                String childId = ((ChildDeviceMessage)msg).getChildDeviceId();
                msg = ((ChildDeviceMessage)msg).getChildDeviceMessage();
                if (deviceId.contains(childId)) {
                    throw new DeviceOperationException(ErrorCode.CYCLIC_DEPENDENCE, "\u5b50\u8bbe\u5907\u6d88\u606f\u5b58\u5728\u5faa\u73af\u5f15\u7528");
                }
                deviceId.add(childId);
            } while (msg instanceof ChildDeviceMessage);
        }
    }

    public String getChildDeviceId() {
        return this.childDeviceId;
    }

    public Message getChildDeviceMessage() {
        return this.childDeviceMessage;
    }

    public void setChildDeviceId(String childDeviceId) {
        this.childDeviceId = childDeviceId;
    }

    public void setChildDeviceMessage(Message childDeviceMessage) {
        this.childDeviceMessage = childDeviceMessage;
    }
}

