/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.util.function.BiConsumer;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;

public class ChildDeviceMessageReply
extends CommonDeviceMessageReply<ChildDeviceMessageReply> {
    private String childDeviceId;
    private Message childDeviceMessage;

    @Override
    public MessageType getMessageType() {
        return MessageType.CHILD_REPLY;
    }

    @Override
    public ChildDeviceMessageReply error(Throwable e) {
        this.doWithChildReply(e, DeviceMessageReply::error);
        return (ChildDeviceMessageReply)super.error(e);
    }

    @Override
    public ChildDeviceMessageReply error(ErrorCode errorCode) {
        this.doWithChildReply(errorCode, DeviceMessageReply::error);
        return (ChildDeviceMessageReply)super.error(errorCode);
    }

    @Override
    public ChildDeviceMessageReply message(String message) {
        this.doWithChildReply(message, DeviceMessageReply::message);
        return (ChildDeviceMessageReply)super.message(message);
    }

    @Override
    public ChildDeviceMessageReply code(String code) {
        this.doWithChildReply(code, DeviceMessageReply::code);
        return (ChildDeviceMessageReply)super.code(code);
    }

    public <T> void doWithChildReply(T arg, BiConsumer<DeviceMessageReply, T> childReplyConsumer) {
        if (this.childDeviceMessage instanceof DeviceMessageReply) {
            DeviceMessageReply child = (DeviceMessageReply)this.childDeviceMessage;
            childReplyConsumer.accept(child, (DeviceMessageReply)arg);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        if (null != this.childDeviceMessage) {
            json.put("childDeviceMessage", (Object)this.childDeviceMessage.toJson());
        }
        return json;
    }

    public String getChildDeviceId() {
        return this.childDeviceId;
    }

    public Message getChildDeviceMessage() {
        return this.childDeviceMessage;
    }

    public void setChildDeviceId(String childDeviceId) {
        this.childDeviceId = childDeviceId;
    }

    public void setChildDeviceMessage(Message childDeviceMessage) {
        this.childDeviceMessage = childDeviceMessage;
    }
}

