/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.DeviceMessage;

public class CommonDeviceMessage
implements DeviceMessage {
    private static final long serialVersionUID = -6849794470754667710L;
    private String code;
    private String messageId;
    private String deviceId;
    private Map<String, Object> headers;
    private long timestamp = System.currentTimeMillis();

    @Override
    public synchronized DeviceMessage addHeader(String header, Object value) {
        if (this.headers == null) {
            this.headers = new ConcurrentHashMap<String, Object>();
        }
        if (header != null && value != null) {
            this.headers.put(header, value);
        }
        return this;
    }

    @Override
    public synchronized DeviceMessage addHeaderIfAbsent(String header, Object value) {
        if (this.headers == null) {
            this.headers = new ConcurrentHashMap<String, Object>();
        }
        if (header != null && value != null) {
            this.headers.putIfAbsent(header, value);
        }
        return this;
    }

    @Override
    public DeviceMessage removeHeader(String header) {
        if (this.headers != null) {
            this.headers.remove(header);
        }
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = (JSONObject)FastBeanCopier.copy((Object)this, (Object)new JSONObject(), (String[])new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        DeviceMessage.super.fromJson(jsonObject);
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

