/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Message;

public class CommonDeviceMessageReply<ME extends CommonDeviceMessageReply>
implements DeviceMessageReply {
    private static final long serialVersionUID = -6849794470754667710L;
    private boolean success = true;
    private String code;
    private String message;
    private String messageId;
    private String deviceId;
    private long timestamp = System.currentTimeMillis();
    private Map<String, Object> headers;

    public synchronized ME addHeaderIfAbsent(String header, Object value) {
        if (this.headers == null) {
            this.headers = new ConcurrentHashMap<String, Object>();
        }
        if (header != null && value != null) {
            this.headers.putIfAbsent(header, value);
        }
        return (ME)this;
    }

    public synchronized ME addHeader(String header, Object value) {
        if (this.headers == null) {
            this.headers = new ConcurrentHashMap<String, Object>();
        }
        if (header != null && value != null) {
            this.headers.put(header, value);
        }
        return (ME)this;
    }

    public ME removeHeader(String header) {
        if (this.headers != null) {
            this.headers.remove(header);
        }
        return (ME)this;
    }

    public ME code(String code) {
        this.code = code;
        return (ME)this;
    }

    public ME message(String message) {
        this.message = message;
        return (ME)this;
    }

    public ME deviceId(String deviceId) {
        this.deviceId = deviceId;
        return (ME)this;
    }

    public ME success() {
        this.success = true;
        return (ME)this;
    }

    public ME error(Throwable e) {
        this.success = false;
        if (e instanceof DeviceOperationException) {
            this.error(((DeviceOperationException)e).getCode());
        } else {
            this.error(ErrorCode.SYSTEM_ERROR);
        }
        this.setMessage(e.getMessage());
        this.addHeader("errorType", (Object)e.getClass().getName());
        this.addHeader("errorMessage", (Object)e.getMessage());
        return (ME)this;
    }

    public ME error(ErrorCode errorCode) {
        this.success = false;
        this.code = errorCode.name();
        this.message = errorCode.getText();
        this.timestamp = System.currentTimeMillis();
        return (ME)this;
    }

    public ME from(Message message) {
        this.messageId = message.getMessageId();
        if (message instanceof DeviceMessage) {
            this.deviceId = ((DeviceMessage)message).getDeviceId();
        }
        return (ME)this;
    }

    public ME messageId(String messageId) {
        this.messageId = messageId;
        return (ME)this;
    }

    public <T> ME addHeader(HeaderKey<T> header, T value) {
        return (ME)((CommonDeviceMessageReply)DeviceMessageReply.super.addHeader((HeaderKey)header, (Object)value));
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = (JSONObject)FastBeanCopier.copy((Object)this, JSONObject::new, (String[])new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        DeviceMessageReply.super.fromJson(jsonObject);
        this.success = jsonObject.getBooleanValue("success");
        this.timestamp = jsonObject.getLongValue("timestamp");
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        this.messageId = jsonObject.getString("messageId");
        this.deviceId = jsonObject.getString("deviceId");
        this.code = jsonObject.getString("code");
        this.message = jsonObject.getString("message");
        this.headers = jsonObject.getJSONObject("headers");
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public static <ME extends CommonDeviceMessageReply> CommonDeviceMessageReplyBuilder<ME> builder() {
        return new CommonDeviceMessageReplyBuilder();
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    @ConstructorProperties(value={"success", "code", "message", "messageId", "deviceId", "timestamp", "headers"})
    public CommonDeviceMessageReply(boolean success, String code, String message, String messageId, String deviceId, long timestamp, Map<String, Object> headers) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.messageId = messageId;
        this.deviceId = deviceId;
        this.timestamp = timestamp;
        this.headers = headers;
    }

    public CommonDeviceMessageReply() {
    }

    public static class CommonDeviceMessageReplyBuilder<ME extends CommonDeviceMessageReply> {
        private boolean success;
        private String code;
        private String message;
        private String messageId;
        private String deviceId;
        private long timestamp;
        private Map<String, Object> headers;

        CommonDeviceMessageReplyBuilder() {
        }

        public CommonDeviceMessageReplyBuilder<ME> success(boolean success) {
            this.success = success;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> code(String code) {
            this.code = code;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> message(String message) {
            this.message = message;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<ME> headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public CommonDeviceMessageReply<ME> build() {
            return new CommonDeviceMessageReply(this.success, this.code, this.message, this.messageId, this.deviceId, this.timestamp, this.headers);
        }

        public String toString() {
            return "CommonDeviceMessageReply.CommonDeviceMessageReplyBuilder(success=" + this.success + ", code=" + this.code + ", message=" + this.message + ", messageId=" + this.messageId + ", deviceId=" + this.deviceId + ", timestamp=" + this.timestamp + ", headers=" + this.headers + ")";
        }
    }
}

