/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetlinks.core.message.BroadcastMessage;
import org.jetlinks.core.message.Message;
import org.springframework.util.StringUtils;

public class DefaultBroadcastMessage
implements BroadcastMessage {
    private static final long serialVersionUID = -6849794470754667710L;
    private String messageId;
    private long timestamp = System.currentTimeMillis();
    private String address;
    private Message message;
    private Map<String, Object> headers;

    @Override
    @Nullable
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    private Map<String, Object> safeGetHeader() {
        return this.headers == null ? (this.headers = new HashMap<String, Object>()) : this.headers;
    }

    @Override
    public synchronized BroadcastMessage addHeader(String header, Object value) {
        if (StringUtils.isEmpty((Object)header) || StringUtils.isEmpty((Object)value)) {
            return this;
        }
        this.safeGetHeader().put(header, value);
        return this;
    }

    @Override
    public synchronized BroadcastMessage addHeaderIfAbsent(String header, Object value) {
        if (StringUtils.isEmpty((Object)header) || StringUtils.isEmpty((Object)value)) {
            return this;
        }
        this.safeGetHeader().putIfAbsent(header, value);
        return this;
    }

    @Override
    public synchronized BroadcastMessage removeHeader(String header) {
        if (StringUtils.isEmpty((Object)header)) {
            return this;
        }
        this.safeGetHeader().remove(header);
        return this;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }
}

