/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.metadata.Jsonable;

public interface Message
extends Jsonable,
Serializable {
    default public MessageType getMessageType() {
        return MessageType.UNKNOWN;
    }

    public String getMessageId();

    public long getTimestamp();

    @Nullable
    public Map<String, Object> getHeaders();

    public Message addHeader(String var1, Object var2);

    public Message addHeaderIfAbsent(String var1, Object var2);

    public Message removeHeader(String var1);

    default public <T> Message addHeader(HeaderKey<T> header, T value) {
        return this.addHeader(header.getKey(), value);
    }

    default public <T> Message addHeaderIfAbsent(HeaderKey<T> header, T value) {
        return this.addHeaderIfAbsent(header.getKey(), value);
    }

    default public <T> Optional<T> getHeader(HeaderKey<T> key) {
        return this.getHeader(key.getKey()).map(v -> TypeUtils.cast((Object)v, key.getType(), (ParserConfig)ParserConfig.global));
    }

    default public <T> T getHeaderOrDefault(HeaderKey<T> key) {
        return (T)this.getHeader(key).orElseGet(key::getDefaultValue);
    }

    default public Optional<Object> getHeader(String header) {
        return Optional.ofNullable(this.getHeaders()).map(headers -> headers.get(header));
    }

    default public void validate() {
    }
}

