/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.AcknowledgeDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DefaultBroadcastMessage;
import org.jetlinks.core.message.DerivedMetadataMessage;
import org.jetlinks.core.message.DeviceLogMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.DirectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessageReply;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.UpdateTagMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessageReply;
import org.jetlinks.core.message.firmware.ReportFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessage;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareProgressMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;

public enum MessageType {
    REPORT_PROPERTY(ReportPropertyMessage::new),
    READ_PROPERTY(ReadPropertyMessage::new),
    WRITE_PROPERTY(WritePropertyMessage::new),
    READ_PROPERTY_REPLY(ReadPropertyMessageReply::new),
    WRITE_PROPERTY_REPLY(WritePropertyMessageReply::new),
    INVOKE_FUNCTION(FunctionInvokeMessage::new){

        @Override
        public <T extends Message> T convert(Map<String, Object> map) {
            Object inputs = map.get("inputs");
            if (inputs instanceof Map) {
                HashMap<String, Object> newMap = new HashMap<String, Object>(map);
                Map inputMap = (Map)newMap.remove("inputs");
                FunctionInvokeMessage message = (FunctionInvokeMessage)super.convert(newMap);
                inputMap.forEach(message::addInput);
                return (T)message;
            }
            return super.convert(map);
        }
    }
    ,
    INVOKE_FUNCTION_REPLY(FunctionInvokeMessageReply::new),
    EVENT(EventMessage::new),
    BROADCAST(DefaultBroadcastMessage::new),
    ONLINE(DeviceOnlineMessage::new),
    OFFLINE(DeviceOfflineMessage::new),
    REGISTER(DeviceRegisterMessage::new),
    UN_REGISTER(DeviceUnRegisterMessage::new),
    DISCONNECT(DisconnectDeviceMessage::new),
    DISCONNECT_REPLY(DisconnectDeviceMessageReply::new),
    DERIVED_METADATA(DerivedMetadataMessage::new),
    CHILD(ChildDeviceMessage::new){

        @Override
        public <T extends Message> T convert(Map<String, Object> map) {
            Object message = map.remove("childDeviceMessage");
            ChildDeviceMessage children = (ChildDeviceMessage)super.convert(map);
            if (message instanceof Map) {
                2.convertMessage((Map)message).ifPresent(children::setChildDeviceMessage);
            }
            return (T)children;
        }
    }
    ,
    CHILD_REPLY(ChildDeviceMessageReply::new){

        @Override
        public <T extends Message> T convert(Map<String, Object> map) {
            Object message = map.remove("childDeviceMessage");
            ChildDeviceMessageReply children = (ChildDeviceMessageReply)super.convert(map);
            if (message instanceof Map) {
                3.convertMessage((Map)message).ifPresent(children::setChildDeviceMessage);
            }
            return (T)children;
        }
    }
    ,
    READ_FIRMWARE(ReadFirmwareMessage::new),
    READ_FIRMWARE_REPLY(ReadFirmwareMessageReply::new),
    REPORT_FIRMWARE(ReportFirmwareMessage::new),
    REQUEST_FIRMWARE(RequestFirmwareMessage::new),
    REQUEST_FIRMWARE_REPLY(RequestFirmwareMessageReply::new),
    UPGRADE_FIRMWARE(UpgradeFirmwareMessage::new),
    UPGRADE_FIRMWARE_REPLY(UpgradeFirmwareMessageReply::new),
    UPGRADE_FIRMWARE_PROGRESS(UpgradeFirmwareProgressMessage::new),
    DIRECT(DirectDeviceMessage::new),
    UPDATE_TAG(UpdateTagMessage::new),
    LOG(DeviceLogMessage::new),
    ACKNOWLEDGE(AcknowledgeDeviceMessage::new),
    STATE_CHECK(DeviceStateCheckMessage::new),
    STATE_CHECK_REPLY(DeviceStateCheckMessageReply::new),
    UNKNOWN(null){

        @Override
        public <T extends Message> T convert(Map<String, Object> map) {
            if (map.containsKey("success")) {
                ChildDeviceMessageReply reply = new ChildDeviceMessageReply();
                reply.fromJson(new JSONObject(map));
                return (T)reply;
            }
            CommonDeviceMessage reply = new CommonDeviceMessage();
            reply.fromJson(new JSONObject(map));
            return (T)reply;
        }
    };

    Supplier<? extends Message> newInstance;
    private static final Map<String, MessageType> mapping;

    public <T extends Message> T convert(Map<String, Object> map) {
        if (this.newInstance != null) {
            try {
                return (T)((Message)FastBeanCopier.copy(map, this.newInstance, (String[])new String[0]));
            }
            catch (Throwable e) {
                return (T)((Message)new JSONObject(map).toJavaObject(this.newInstance.get().getClass()));
            }
        }
        return null;
    }

    public static <T extends Message> Optional<T> convertMessage(Map<String, Object> map) {
        return MessageType.of(map).map(type -> type.convert(map));
    }

    public static Optional<MessageType> of(String name) {
        return Optional.ofNullable(mapping.get(name));
    }

    public static Optional<MessageType> of(Map<String, Object> map) {
        Object msgType = map.get("messageType");
        if (msgType instanceof MessageType) {
            return Optional.of((MessageType)((Object)msgType));
        }
        if (msgType instanceof String) {
            return MessageType.of((String)msgType);
        }
        if (map.containsKey("event")) {
            return Optional.of(EVENT);
        }
        if (map.containsKey("functionId")) {
            return map.containsKey("inputs") ? Optional.of(INVOKE_FUNCTION) : Optional.of(INVOKE_FUNCTION_REPLY);
        }
        if (map.containsKey("properties")) {
            Object properties = map.get("properties");
            return properties instanceof Collection ? Optional.of(READ_PROPERTY) : Optional.of(READ_PROPERTY_REPLY);
        }
        if (map.containsKey("tags")) {
            return Optional.of(UPDATE_TAG);
        }
        if (map.containsKey("success")) {
            return Optional.of(ACKNOWLEDGE);
        }
        return Optional.of(UNKNOWN);
    }

    @ConstructorProperties(value={"newInstance"})
    private MessageType(Supplier<? extends Message> newInstance) {
        this.newInstance = newInstance;
    }

    static {
        mapping = new HashMap<String, MessageType>();
        for (MessageType value : MessageType.values()) {
            mapping.put(value.name().toLowerCase(), value);
            mapping.put(value.name().toUpperCase(), value);
        }
    }
}

