/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.core.message.codec.EncodedMessage;

public interface CoapMessage
extends EncodedMessage {
    @Nonnull
    public String getPath();

    @Nonnull
    public CoAP.Code getCode();

    @Nonnull
    public List<Option> getOptions();

    @Nonnull
    default public Optional<Option> getOption(int number) {
        return this.getOptions().stream().filter(opt -> opt.getNumber() == number).findFirst();
    }

    @Nonnull
    default public Optional<String> getStringOption(int number) {
        return this.getOption(number).map(Option::getStringValue);
    }

    @Nonnull
    default public Optional<Integer> getIntOption(int number) {
        return this.getOption(number).map(Option::getIntegerValue);
    }

    default public Request createRequest() {
        Request request = new Request(this.getCode());
        request.setURI(this.getPath());
        request.setPayload(this.payloadAsBytes());
        this.getOptions().forEach(arg_0 -> ((OptionSet)request.getOptions()).addOption(arg_0));
        return request;
    }

    default public String print(boolean pretty) {
        StringBuilder builder = new StringBuilder().append(this.getCode().name()).append(" ").append(this.getPath()).append("\n");
        for (Option option : this.getOptions()) {
            builder.append(option).append("\n");
        }
        builder.append("\n");
        ByteBuf byteBuf = this.getPayload();
        if (this.getOption(12).isPresent()) {
            builder.append(byteBuf.toString(StandardCharsets.UTF_8));
        } else if (pretty) {
            ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)this.getPayload());
        } else {
            builder.append(Hex.encodeHex((byte[])this.payloadAsBytes()));
        }
        return builder.toString();
    }

    public static Option parseOption(String option, String value) {
        boolean valueIsNumber = StringUtils.isNumber((Object)option);
        boolean valueIsHex = value.startsWith("0x");
        int num = OptionNumberRegistry.toNumber((String)option);
        if (num == -1 && valueIsNumber) {
            num = Integer.parseInt(option);
        }
        if (num == 12 && !valueIsNumber) {
            return new Option(num, MediaTypeRegistry.parse((String)value));
        }
        if (OptionNumberRegistry.getFormatByNr((int)num) == OptionNumberRegistry.optionFormats.INTEGER) {
            return new Option(num, new BigDecimal(value).longValue());
        }
        if (valueIsHex) {
            return new Option(num, ByteBufUtil.decodeHexDump((CharSequence)value.substring(2)));
        }
        return new Option(num, value);
    }
}

