/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vavr.CheckedConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.CoapResponseMessage;
import org.jetlinks.core.message.codec.TextMessageParser;

public class DefaultCoapResponseMessage
implements CoapResponseMessage {
    @Nonnull
    private CoAP.ResponseCode code;
    private List<Option> options;
    private ByteBuf payload;

    public static DefaultCoapResponseMessage of(String text) {
        DefaultCoapResponseMessage msg = new DefaultCoapResponseMessage();
        ArrayList<Option> options = new ArrayList<Option>();
        msg.setOptions(options);
        TextMessageParser.of((CheckedConsumer<String>)((CheckedConsumer)start -> {
            String str;
            String[] arr = start.split("[ ]");
            String string = str = arr.length == 1 ? arr[0] : arr[1];
            if (str.contains(".")) {
                String[] codeArr = str.split("[.]");
                msg.setCode(CoAP.ResponseCode.valueOf((int)(Integer.parseInt(codeArr[0]) << 5 | Integer.parseInt(codeArr[1]))));
            } else {
                msg.setCode(CoAP.ResponseCode.valueOf((String)str));
            }
        }), (option, value) -> options.add(CoapMessage.parseOption(option, value)), (CheckedConsumer<TextMessageParser.Payload>)((CheckedConsumer)body -> msg.setPayload(Unpooled.wrappedBuffer((byte[])body.getBody()))), () -> msg.setPayload(Unpooled.wrappedBuffer((byte[])new byte[0]))).parse(text);
        return msg;
    }

    public static DefaultCoapResponseMessage of(CoapResponse response) {
        DefaultCoapResponseMessage msg = new DefaultCoapResponseMessage();
        msg.setCode(response.getCode());
        msg.setOptions(response.getOptions().asSortedList());
        msg.setPayload(Unpooled.wrappedBuffer((byte[])(response.getPayload() == null ? new byte[]{} : response.getPayload())));
        return msg;
    }

    @Override
    @Nonnull
    public CoAP.ResponseCode getCode() {
        return this.code;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setCode(@Nonnull CoAP.ResponseCode code) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        this.code = code;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }
}

