/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import reactor.core.publisher.Mono;

public interface MessageCodecContext {
    @Nullable
    public DeviceOperator getDevice();

    default public Mono<DeviceOperator> getDeviceAsync() {
        return Mono.justOrEmpty((Object)this.getDevice());
    }

    default public Mono<DeviceOperator> getDevice(String deviceId) {
        return Mono.empty();
    }

    default public Map<String, Object> getConfiguration() {
        return Collections.emptyMap();
    }

    default public Optional<Object> getConfig(String key) {
        return Optional.ofNullable(this.getConfiguration()).map(conf -> conf.get(key));
    }
}

