/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.EncodedMessage;

public interface MqttMessage
extends EncodedMessage {
    @Nonnull
    public String getTopic();

    public String getClientId();

    public int getMessageId();

    default public boolean isWill() {
        return false;
    }

    default public int getQosLevel() {
        return 0;
    }

    default public boolean isDup() {
        return false;
    }

    default public boolean isRetain() {
        return false;
    }

    default public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append("qos").append(this.getQosLevel()).append(" ").append(this.getTopic()).append("\n").append("messageId: ").append(this.getMessageId()).append("\n").append("dup: ").append(this.isDup()).append("\n").append("retain: ").append(this.isRetain()).append("\n").append("will: ").append(this.isWill()).append("\n\n");
        ByteBuf payload = this.getPayload();
        if (ByteBufUtil.isText((ByteBuf)payload, (Charset)StandardCharsets.UTF_8)) {
            builder.append(payload.toString(StandardCharsets.UTF_8));
        } else {
            ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)payload);
        }
        return builder.toString();
    }
}

