/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessagePayloadType;

public class SimpleEncodedMessage
implements EncodedMessage {
    private final ByteBuf payload;
    private final MessagePayloadType payloadType;

    public static SimpleEncodedMessage of(ByteBuf byteBuf, MessagePayloadType payloadType) {
        return new SimpleEncodedMessage(byteBuf, payloadType);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (ByteBufUtil.isText((ByteBuf)this.payload, (Charset)StandardCharsets.UTF_8)) {
            builder.append(this.payload.toString(StandardCharsets.UTF_8));
        } else {
            ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)this.payload);
        }
        return builder.toString();
    }

    @ConstructorProperties(value={"payload", "payloadType"})
    public SimpleEncodedMessage(ByteBuf payload, MessagePayloadType payloadType) {
        this.payload = payload;
        this.payloadType = payloadType;
    }

    @Override
    public ByteBuf getPayload() {
        return this.payload;
    }

    @Override
    public MessagePayloadType getPayloadType() {
        return this.payloadType;
    }
}

