/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.vavr.CheckedConsumer;
import io.vavr.CheckedRunnable;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Hex;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.springframework.util.StringUtils;

public class TextMessageParser {
    private final CheckedConsumer<String> startConsumer;
    private final BiConsumer<String, String> headerConsumer;
    private final CheckedConsumer<Payload> bodyConsumer;
    private final CheckedRunnable noBodyConsumer;

    public void parse(String text) {
        String[] lines = text.trim().split("[\n]");
        int lineIndex = 0;
        for (String line : lines) {
            if ((line = line.trim()).startsWith("//")) continue;
            if (StringUtils.isEmpty((Object)line)) {
                if (lineIndex <= 0) continue;
                break;
            }
            if (lineIndex++ == 0) {
                this.startConsumer.accept((Object)line);
                continue;
            }
            String[] header = line.split("[:]");
            if (header.length <= 1) continue;
            this.headerConsumer.accept(header[0].trim(), header[1].trim());
        }
        if (lineIndex < lines.length) {
            byte[] data;
            MessagePayloadType type;
            String body = String.join((CharSequence)"\n", Arrays.copyOfRange(lines, lineIndex, lines.length)).trim();
            if (body.startsWith("0x")) {
                type = MessagePayloadType.BINARY;
                body = body.substring(2);
                data = Hex.decodeHex((String)body);
            } else if (body.startsWith("{") || body.startsWith("[")) {
                type = MessagePayloadType.JSON;
                data = body.getBytes();
            } else {
                type = MessagePayloadType.STRING;
                data = body.getBytes();
            }
            this.bodyConsumer.accept((Object)new Payload(type, body, data));
        } else {
            this.noBodyConsumer.run();
        }
    }

    @ConstructorProperties(value={"startConsumer", "headerConsumer", "bodyConsumer", "noBodyConsumer"})
    private TextMessageParser(CheckedConsumer<String> startConsumer, BiConsumer<String, String> headerConsumer, CheckedConsumer<Payload> bodyConsumer, CheckedRunnable noBodyConsumer) {
        this.startConsumer = startConsumer;
        this.headerConsumer = headerConsumer;
        this.bodyConsumer = bodyConsumer;
        this.noBodyConsumer = noBodyConsumer;
    }

    public static TextMessageParser of(CheckedConsumer<String> startConsumer, BiConsumer<String, String> headerConsumer, CheckedConsumer<Payload> bodyConsumer, CheckedRunnable noBodyConsumer) {
        return new TextMessageParser(startConsumer, headerConsumer, bodyConsumer, noBodyConsumer);
    }

    public static class Payload {
        private final MessagePayloadType type;
        private final String bodyString;
        private final byte[] body;

        public MessagePayloadType getType() {
            return this.type;
        }

        public String getBodyString() {
            return this.bodyString;
        }

        public byte[] getBody() {
            return this.body;
        }

        @ConstructorProperties(value={"type", "bodyString", "body"})
        public Payload(MessagePayloadType type, String bodyString, byte[] body) {
            this.type = type;
            this.bodyString = bodyString;
            this.body = body;
        }
    }
}

