/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.message.codec.Transport;

public class Transports {
    private static final Map<String, Transport> all = new ConcurrentHashMap<String, Transport>();

    public static void register(Collection<Transport> transport) {
        transport.forEach(Transports::register);
    }

    public static void register(Transport transport) {
        all.put(transport.getId().toUpperCase(), transport);
    }

    public static List<Transport> get() {
        return new ArrayList<Transport>(all.values());
    }

    public static Optional<Transport> lookup(String id) {
        return Optional.ofNullable(all.get(id.toUpperCase()));
    }
}

