/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionParameter;

public class FunctionInvokeMessage
extends CommonDeviceMessage
implements RepayableDeviceMessage<FunctionInvokeMessageReply> {
    private String functionId;
    private List<FunctionParameter> inputs = new ArrayList<FunctionParameter>();

    @Override
    public MessageType getMessageType() {
        return MessageType.INVOKE_FUNCTION;
    }

    public Optional<Object> getInput(String name) {
        return this.inputs.stream().filter(param -> param.getName().equals(name)).map(FunctionParameter::getValue).findFirst();
    }

    public Optional<Object> getInput(int index) {
        return this.inputs.size() > index ? Optional.ofNullable(this.inputs.get(index)) : Optional.empty();
    }

    public Map<String, Object> inputsToMap() {
        return this.inputs.stream().collect(Collectors.toMap(FunctionParameter::getName, FunctionParameter::getValue, (a, b) -> a));
    }

    public <T> T inputsToBean(Class<T> beanType) {
        return (T)new JSONObject(this.inputsToMap()).toJavaObject(beanType);
    }

    public List<Object> inputsToList() {
        return this.inputs.stream().map(FunctionParameter::getValue).collect(Collectors.toList());
    }

    public Object[] inputsToArray() {
        return this.inputs.stream().map(FunctionParameter::getValue).toArray();
    }

    public FunctionInvokeMessage addInput(String name, Object value) {
        return this.addInput(new FunctionParameter(name, value));
    }

    public FunctionInvokeMessage addInput(FunctionParameter parameter) {
        this.inputs.add(parameter);
        return this;
    }

    @Override
    public FunctionInvokeMessage addHeader(String header, Object value) {
        super.addHeader(header, value);
        return this;
    }

    @Override
    public FunctionInvokeMessage removeHeader(String header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.functionId = jsonObject.getString("functionId");
    }

    @Override
    public FunctionInvokeMessageReply newReply() {
        FunctionInvokeMessageReply reply = (FunctionInvokeMessageReply)new FunctionInvokeMessageReply().from(this);
        reply.setFunctionId(this.functionId);
        return reply;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public List<FunctionParameter> getInputs() {
        return this.inputs;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setInputs(List<FunctionParameter> inputs) {
        this.inputs = inputs;
    }
}

