/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.interceptor;

import org.jetlinks.core.device.CompositeDeviceMessageSenderInterceptor;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.DeviceMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceMessageSenderInterceptor {
    public static final DeviceMessageSenderInterceptor DO_NOTING = new DeviceMessageSenderInterceptor(){};

    default public Mono<DeviceMessage> preSend(DeviceOperator device, DeviceMessage message) {
        return Mono.just((Object)message);
    }

    default public <R extends DeviceMessage> Flux<R> afterSent(DeviceOperator device, DeviceMessage message, Flux<R> reply) {
        return reply;
    }

    default public DeviceMessageSenderInterceptor andThen(DeviceMessageSenderInterceptor interceptor) {
        if (this == DO_NOTING) {
            return interceptor;
        }
        CompositeDeviceMessageSenderInterceptor composite = new CompositeDeviceMessageSenderInterceptor();
        composite.addInterceptor(this);
        composite.addInterceptor(interceptor);
        return composite;
    }
}

