/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;

public class WritePropertyMessageReply
extends CommonDeviceMessageReply<WritePropertyMessageReply> {
    private Map<String, Object> properties;

    public synchronized WritePropertyMessageReply addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
        return this;
    }

    public static WritePropertyMessageReply create() {
        WritePropertyMessageReply reply = new WritePropertyMessageReply();
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    public Optional<Object> getProperty(String property) {
        return Optional.ofNullable(this.properties).map(map -> map.get(property));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.properties = jsonObject.getJSONObject("properties");
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.WRITE_PROPERTY_REPLY;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

