/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DataType;

public class DefaultConfigMetadata
implements ConfigMetadata {
    private static final long serialVersionUID = 0L;
    private String name;
    private String description;
    private ConfigScope[] scopes;
    private List<ConfigPropertyMetadata> properties = new ArrayList<ConfigPropertyMetadata>();

    public DefaultConfigMetadata() {
    }

    public DefaultConfigMetadata(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public ConfigScope[] getScopes() {
        return this.scopes == null ? ConfigMetadata.super.getScopes() : this.scopes;
    }

    @Override
    public List<ConfigPropertyMetadata> getProperties() {
        return this.properties;
    }

    public DefaultConfigMetadata scope(ConfigScope ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public DefaultConfigMetadata add(ConfigPropertyMetadata metadata) {
        this.properties.add(metadata);
        return this;
    }

    public DefaultConfigMetadata add(String property, String name, DataType type) {
        return this.add(property, name, null, type);
    }

    public DefaultConfigMetadata add(String property, String name, String description, DataType type) {
        return this.add(Property.of(property, name, description, type, all));
    }

    public DefaultConfigMetadata add(String property, String name, DataType type, ConfigScope ... scopes) {
        return this.add(property, name, null, type, scopes);
    }

    public DefaultConfigMetadata add(String property, String name, String description, DataType type, ConfigScope ... scopes) {
        return this.add(Property.of(property, name, description, type, scopes));
    }

    @Override
    public DefaultConfigMetadata copy(ConfigScope ... scopes) {
        DefaultConfigMetadata configMetadata = new DefaultConfigMetadata(this.name, this.description);
        configMetadata.scopes = this.scopes;
        configMetadata.properties = scopes == null || scopes.length == 0 ? new ArrayList<ConfigPropertyMetadata>(this.properties) : this.properties.stream().filter(conf -> conf.hasAnyScope(scopes)).collect(Collectors.toList());
        return configMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScopes(ConfigScope[] scopes) {
        this.scopes = scopes;
    }

    public void setProperties(List<ConfigPropertyMetadata> properties) {
        this.properties = properties;
    }

    public static class Property
    implements ConfigPropertyMetadata {
        private static final long serialVersionUID = 0L;
        private String property;
        private String name;
        private String description;
        private DataType type;
        private ConfigScope[] scopes;

        public static PropertyBuilder builder() {
            return new PropertyBuilder();
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public DataType getType() {
            return this.type;
        }

        @Override
        public ConfigScope[] getScopes() {
            return this.scopes;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(DataType type) {
            this.type = type;
        }

        public void setScopes(ConfigScope[] scopes) {
            this.scopes = scopes;
        }

        public Property() {
        }

        @ConstructorProperties(value={"property", "name", "description", "type", "scopes"})
        private Property(String property, String name, String description, DataType type, ConfigScope[] scopes) {
            this.property = property;
            this.name = name;
            this.description = description;
            this.type = type;
            this.scopes = scopes;
        }

        public static Property of(String property, String name, String description, DataType type, ConfigScope[] scopes) {
            return new Property(property, name, description, type, scopes);
        }

        public static class PropertyBuilder {
            private String property;
            private String name;
            private String description;
            private DataType type;
            private ConfigScope[] scopes;

            PropertyBuilder() {
            }

            public PropertyBuilder property(String property) {
                this.property = property;
                return this;
            }

            public PropertyBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PropertyBuilder description(String description) {
                this.description = description;
                return this;
            }

            public PropertyBuilder type(DataType type) {
                this.type = type;
                return this;
            }

            public PropertyBuilder scopes(ConfigScope[] scopes) {
                this.scopes = scopes;
                return this;
            }

            public Property build() {
                return new Property(this.property, this.name, this.description, this.type, this.scopes);
            }

            public String toString() {
                return "DefaultConfigMetadata.Property.PropertyBuilder(property=" + this.property + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", scopes=" + Arrays.deepToString(this.scopes) + ")";
            }
        }
    }
}

