/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.PropertyMetadata;

public interface MergeOption {
    public static final MergeOption ignoreExists = DefaultMergeOption.ignoreExists;
    public static final MergeOption overwriteProperty = DefaultMergeOption.overwriteProperty;
    public static final MergeOption[] DEFAULT_OPTIONS = new MergeOption[0];

    public static PropertyFilter propertyFilter(PropertyFilter filter) {
        return filter;
    }

    public String getId();

    public static boolean has(MergeOption option, MergeOption ... target) {
        for (MergeOption mergeOption : target) {
            if (!Objects.equals(option, mergeOption)) continue;
            return true;
        }
        return false;
    }

    public static class ExpandsMerge
    implements MergeOption {
        private static final ExpandsMerge all = new ExpandsMerge(null, Type.ignore){

            @Override
            public boolean isIgnore(String key) {
                return true;
            }

            @Override
            public void mergeExpands(Map<String, Object> from, BiConsumer<String, Object> to) {
            }
        };
        private final Set<String> keys;
        private final Type type;

        public static ExpandsMerge ignore(String ... keys) {
            return new ExpandsMerge(Arrays.stream(keys).collect(Collectors.toSet()), Type.ignore);
        }

        public static ExpandsMerge remove(String ... keys) {
            return new ExpandsMerge(Arrays.stream(keys).collect(Collectors.toSet()), Type.remove);
        }

        public ExpandsMerge ignoreAll() {
            return all;
        }

        @Override
        public String getId() {
            return "expandsMerge";
        }

        public boolean isIgnore(String key) {
            return this.keys.contains(key);
        }

        public static Optional<ExpandsMerge> from(MergeOption option) {
            if (option instanceof ExpandsMerge) {
                return Optional.of((ExpandsMerge)option);
            }
            return Optional.empty();
        }

        public void mergeExpands(Map<String, Object> from, BiConsumer<String, Object> to) {
            from.forEach((key, value) -> {
                if (!this.isIgnore((String)key)) {
                    to.accept((String)key, value);
                }
            });
        }

        public static void doWith(DeviceMetadataType metadataType, Map<String, Object> from, Map<String, Object> to, MergeOption ... options) {
            if (MapUtils.isEmpty(from)) {
                return;
            }
            boolean merged = false;
            if (options != null && options.length != 0) {
                for (MergeOption option : options) {
                    ExpandsMerge expandsOption = ExpandsMerge.from(option).orElse(null);
                    if (null == expandsOption) continue;
                    merged = true;
                    expandsOption.mergeExpands(from, to::put);
                    if (expandsOption.type != Type.remove) continue;
                    expandsOption.keys.forEach(to::remove);
                }
            }
            if (!merged) {
                from.forEach(to::put);
            }
        }

        @ConstructorProperties(value={"keys", "type"})
        private ExpandsMerge(Set<String> keys, Type type) {
            this.keys = keys;
            this.type = type;
        }

        private static enum Type {
            ignore,
            remove;

        }
    }

    public static interface PropertyFilter
    extends MergeOption,
    Predicate<PropertyMetadata> {
        @Override
        default public String getId() {
            return "PropertyFilter";
        }

        @Override
        public boolean test(PropertyMetadata var1);

        public static boolean doFilter(PropertyMetadata metadata, MergeOption ... option) {
            for (MergeOption mergeOption : option) {
                if (!(mergeOption instanceof PropertyFilter) || ((PropertyFilter)mergeOption).test(metadata)) continue;
                return false;
            }
            return true;
        }

        public static boolean has(MergeOption[] options) {
            for (MergeOption option : options) {
                if (!(option instanceof PropertyFilter)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum DefaultMergeOption implements MergeOption
    {
        ignoreExists,
        mergeExpands,
        overwriteProperty;


        @Override
        public String getId() {
            return this.name();
        }
    }
}

