/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;

public class EnumType
extends AbstractType<EnumType>
implements DataType {
    public static final String ID = "enum";
    private volatile List<Element> elements;
    private boolean multi;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "\u679a\u4e3e";
    }

    public EnumType multi(boolean multi) {
        this.multi = multi;
        return this;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (this.elements == null) {
            return ValidateResult.fail("\u503c[" + value + "]\u4e0d\u5728\u679a\u4e3e\u4e2d");
        }
        return this.elements.stream().filter(ele -> this.match(value, (Element)ele)).findFirst().map(e -> ValidateResult.success(((Element)e).value)).orElseGet(() -> ValidateResult.fail("\u503c[" + value + "]\u4e0d\u5728\u679a\u4e3e\u4e2d"));
    }

    private boolean match(Object value, Element ele) {
        if (value instanceof Map) {
            Map mapVal = (Map)value;
            return this.match(mapVal.getOrDefault("value", mapVal.get("id")), ele);
        }
        return ele.value.equals(String.valueOf(value)) || ele.text.equals(String.valueOf(value));
    }

    @Override
    public String format(Object value) {
        String stringVal = String.valueOf(value);
        if (this.elements == null) {
            return stringVal;
        }
        return this.elements.stream().filter(ele -> ((Element)ele).value.equals(String.valueOf(value))).findFirst().map(Element::getText).orElse(stringVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumType addElement(Element element) {
        if (this.elements == null) {
            EnumType enumType = this;
            synchronized (enumType) {
                if (this.elements == null) {
                    this.elements = new ArrayList<Element>();
                }
            }
        }
        this.elements.add(element);
        return this;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public static class Element {
        private String value;
        private String text;
        private String description;

        public static Element of(String value, String text) {
            return Element.of(value, text, null);
        }

        public static Element of(Map<String, String> map) {
            return Element.of(map.get("value"), map.get("text"), map.get("description"));
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", this.value);
            map.put("text", this.text);
            map.put("description", this.description);
            return map;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @ConstructorProperties(value={"value", "text", "description"})
        private Element(String value, String text, String description) {
            this.value = value;
            this.text = text;
            this.description = description;
        }

        public static Element of(String value, String text, String description) {
            return new Element(value, text, description);
        }

        public Element() {
        }
    }
}

