/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.math.BigDecimal;
import org.jetlinks.core.metadata.types.NumberType;

public class FloatType
extends NumberType<Float> {
    public static final String ID = "float";
    private Integer scale;
    public static final FloatType GLOBAL = new FloatType();

    @Override
    public Object format(Object value) {
        Number val = this.convertNumber(value);
        if (val == null) {
            return super.format(value);
        }
        int scale = this.scale == null ? 2 : this.scale;
        String scaled = new BigDecimal(val.toString()).setScale(scale, 4).toString();
        return super.format(scaled);
    }

    public FloatType scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public Float convert(Object value) {
        return super.convertNumber(value, Number::floatValue);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "\u5355\u7cbe\u5ea6\u6d6e\u70b9\u6570";
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

