/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.metadata.types.GeoPoint;

public class GeoShape
implements Serializable {
    private Type type;
    private List<Object> coordinates;

    public static GeoShape of(Object value) {
        if (value instanceof GeoShape) {
            return (GeoShape)value;
        }
        if (value instanceof GeoPoint) {
            return GeoShape.fromPoint((GeoPoint)value);
        }
        if (value instanceof String && ((String)value).startsWith("{")) {
            value = JSON.parseObject((String)String.valueOf(value));
        }
        if (value instanceof Map) {
            return GeoShape.of((Map)value);
        }
        throw new IllegalArgumentException("unsupported GeoShape:" + value);
    }

    public static GeoShape of(Map<String, Object> map) {
        GeoShape shape = new GeoShape();
        shape.type = Type.of(map.get("type"));
        shape.coordinates = shape.type.parseCoordinates(map.get("coordinates"));
        return shape;
    }

    public static GeoShape fromPoint(GeoPoint point) {
        GeoShape shape = new GeoShape();
        shape.type = Type.Point;
        shape.coordinates = new ArrayList<Double>(Arrays.asList(point.getLon(), point.getLat()));
        return shape;
    }

    public Type getType() {
        return this.type;
    }

    public List<Object> getCoordinates() {
        return this.coordinates;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setCoordinates(List<Object> coordinates) {
        this.coordinates = coordinates;
    }

    public static enum Type {
        Point,
        MultiPoint,
        LineString,
        MultiLineString,
        Polygon,
        MultiPolygon,
        GeometryCollection;


        public static Type of(Object val) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(String.valueOf(val))) continue;
                return value;
            }
            throw new IllegalArgumentException("unsupported GeoShape type:" + val);
        }

        public List<Object> parseCoordinates(Object coordinates) {
            if (coordinates instanceof Collection) {
                return new ArrayList<Object>((Collection)coordinates);
            }
            if (coordinates instanceof String) {
                if (((String)coordinates).startsWith("[")) {
                    return JSON.parseArray((String)String.valueOf(coordinates));
                }
                return new ArrayList<Object>(Arrays.asList(((String)coordinates).split(",")));
            }
            throw new IllegalArgumentException("unsupported coordinates type :" + coordinates);
        }
    }
}

