/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.UnitSupported;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.unit.ValueUnit;

public abstract class NumberType<N extends Number>
extends AbstractType<NumberType<N>>
implements UnitSupported,
DataType,
Converter<N> {
    private Number max;
    private Number min;
    private ValueUnit unit;

    public NumberType<N> unit(ValueUnit unit) {
        this.unit = unit;
        return this;
    }

    public NumberType<N> max(Number max) {
        this.max = max;
        return this;
    }

    public NumberType<N> min(Number min) {
        this.min = min;
        return this;
    }

    @Override
    public Object format(Object value) {
        if (value == null) {
            return null;
        }
        ValueUnit unit = this.getUnit();
        if (unit == null) {
            return value;
        }
        return unit.format(value);
    }

    @Override
    public ValidateResult validate(Object value) {
        try {
            Object numberValue = this.convert(value);
            if (numberValue == null) {
                return ValidateResult.fail("\u6570\u5b57\u683c\u5f0f\u9519\u8bef:" + value);
            }
            if (this.max != null && ((Number)numberValue).doubleValue() > this.max.doubleValue()) {
                return ValidateResult.fail("\u8d85\u8fc7\u6700\u5927\u503c:" + this.max);
            }
            if (this.min != null && ((Number)numberValue).doubleValue() < this.min.doubleValue()) {
                return ValidateResult.fail("\u8d85\u8fc7\u6700\u5927\u503c:" + this.min);
            }
            return ValidateResult.success(numberValue);
        }
        catch (NumberFormatException e) {
            return ValidateResult.fail(e.getMessage());
        }
    }

    public N convertNumber(Object value, Function<Number, N> mapper) {
        return (N)((Number)Optional.ofNullable(this.convertNumber(value)).map(mapper).orElse(null));
    }

    public Number convertNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return null;
    }

    @Override
    public abstract N convert(Object var1);

    public long getMax(long defaultVal) {
        return Optional.ofNullable(this.getMax()).map(Number::longValue).orElse(defaultVal);
    }

    public long getMin(long defaultVal) {
        return Optional.ofNullable(this.getMin()).map(Number::longValue).orElse(defaultVal);
    }

    public double getMax(double defaultVal) {
        return Optional.ofNullable(this.getMax()).map(Number::doubleValue).orElse(defaultVal);
    }

    public double getMin(double defaultVal) {
        return Optional.ofNullable(this.getMin()).map(Number::doubleValue).orElse(defaultVal);
    }

    public Number getMax() {
        return this.max;
    }

    public Number getMin() {
        return this.min;
    }

    @Override
    public ValueUnit getUnit() {
        return this.unit;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    @Override
    public void setUnit(ValueUnit unit) {
        this.unit = unit;
    }
}

